//-----------------------------------------------------------------------
// <copyright file=" im_data.cs">
// * FileName: im_data.cs
// </copyright>
//-----------------------------------------------------------------------
using System.Collections.Generic;
using Performance.EntityModels;

namespace Performance.Repository
{
    /// <summary>
    /// im_data Repository
    /// </summary>
    public partial class PerforImdataRepository : PerforRepository<im_data>
    {
        /// <summary>
        /// ȡ㵥Ԫ
        /// </summary>
        /// <param name="deptList">б</param>
        /// <param name="hospitalid">ҽԺid</param>
        /// <param name="sheetType">sheetģ</param>
        /// <returns></returns>
        public IEnumerable<im_data> GetAccountingUnit(int hospitalid, int sheettype, List<string> deptList)
        {
            string sql = "select distinct im.accountingUnit,im.department,im.unittype from im_data im " +
                "inner join per_allot allot on im.AllotID = allot.ID " +
                "inner join per_sheet sheet on im.SheetID = sheet.ID " +
                "where allot.hospitalid = @hospitalid and sheet.sheettype = @sheettype and im.department in @deptList";
            return DapperQuery(sql, new { hospitalid, sheettype, deptList }, 1000 * 60 * 5);
        }

        /// <summary>
        /// ȡ㵥Ԫ
        /// </summary>
        /// <returns></returns>
        public IEnumerable<AccountUnitEntity> GetAccountUnit(int allotId)
        {
            string sql = "select distinct SheetName,AccountingUnit,Department,UnitType from per_sheet st join im_data dt on st.ID = dt.SheetID where st.AllotID = @allotId and ifnull(AccountingUnit, '') != '' ";
            return DapperQuery<AccountUnitEntity>(sql, new { allotId }, 1000 * 60 * 5);
        }
    }
}
