//-----------------------------------------------------------------------
// <copyright file=" per_apr_amount.cs">
// * FileName: per_apr_amount.cs
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using Dapper;
using Performance.EntityModels;

namespace Performance.Repository
{
    /// <summary>
    /// per_apr_amount Repository
    /// </summary>
    public partial class PerforPerapramountRepository : PerforRepository<per_apr_amount>
    {
        //public List<view_per_apr_amount> GetFullAmount(Expression<Func<per_apr_amount, bool>> predicate)
        //{
        //    var amounts = GetEntities(predicate);
        //    if (amounts == null || !amounts.Any())
        //        return new List<view_per_apr_amount>();

        //    var ids = amounts.Select(w => w.AllotId).Distinct().ToList();

        //    var employees = this.context.Set<per_employee>()
        //        .Where(w => w.AllotId.HasValue && ids.Contains(w.AllotId.Value))
        //        .Select(w => new
        //        {
        //            UnitType = w.UnitType,
        //            AccountingUnit = w.AccountingUnit,
        //            AllotId = w.AllotId,
        //            PersonnelNumber = w.PersonnelNumber,
        //            DoctorName = w.DoctorName,
        //        });

        //    var res = from outer in amounts
        //              join inner in employees
        //              on new { outer.AllotId, outer.PersonnelNumber } equals new { AllotId = inner.AllotId ?? 0, inner.PersonnelNumber } into temp
        //              from tt in temp.DefaultIfEmpty()
        //              select new view_per_apr_amount
        //              {
        //                  Id = outer.Id,
        //                  AllotId = outer.AllotId,
        //                  PersonnelNumber = outer.PersonnelNumber,
        //                  PerforType = outer.PerforType,
        //                  Amount = outer.Amount,
        //                  DoctorName = tt?.DoctorName ?? "",
        //                  AccountingUnit = tt?.AccountingUnit ?? "",
        //                  UnitType = tt?.UnitType ?? "",
        //                  TypeInDepartment = outer.TypeInDepartment,
        //                  Status = outer.Status,
        //                  AuditTime = outer.AuditTime,
        //                  AuditUser = outer.AuditUser,
        //                  CreateDate = outer.CreateDate,
        //                  CreateUser = outer.CreateUser,
        //                  Remark = outer.Remark,
        //                  IsVerify = outer.IsVerify,
        //                  VerifyMessage = outer.VerifyMessage,
        //              };
        //    return res.ToList() ?? new List<view_per_apr_amount>();
        //}


        public List<view_per_apr_amount> GetFullAmount(int? allotId, int? status, string typeInDepartment = "", DateTime? date = null)
        {
            string sql = "select AllotId, PersonnelNumber, Trim(AccountingUnit) AccountingUnit, UnitType, DoctorName, PerforType, Amount, TypeInDepartment, Status, Remark from view_other_amount where ifnull(amount,0)<>0 ";

            DynamicParameters parameters = new DynamicParameters();

            if (allotId.HasValue && allotId > 0)
            {
                sql += " and allotId = @allotId";
                parameters.Add("allotId", allotId);
            }
            if (status.HasValue && status > 0)
            {
                sql += " and status = @status";
                parameters.Add(name: "status", status);
            }
            if (!string.IsNullOrEmpty(typeInDepartment))
            {
                sql += " and typeInDepartment = @typeInDepartment";
                parameters.Add(name: "typeInDepartment", typeInDepartment);
            }
            if (date.HasValue)
            {
                sql += " and createDate = @createDate";
                parameters.Add(name: "createDate", date);
            }

            return DapperQuery<view_per_apr_amount>(sql, parameters).ToList();
        }
    }
}
