//-----------------------------------------------------------------------
// <copyright file=" per_employee.cs">
// * FileName: per_employee.cs
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Linq.Expressions;
using Masuit.Tools.Models;
using Microsoft.EntityFrameworkCore;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Infrastructure.Models;

namespace Performance.Repository
{
    /// <summary>
    /// per_employee Repository
    /// </summary>
    public partial class PerforPeremployeeRepository : PerforRepository<per_employee>
    {

        public new PageList<per_employee> GetEntitiesForPaging(int pageNumber, int pageSize, Expression<Func<per_employee, bool>> exp)
        {
            IQueryable<per_employee> queryableAuthors = context.Set<per_employee>().Where(exp).OrderBy(w => w.IsVerify).ThenBy(t => t.JobNumber);

            return PageList<per_employee>.Create(queryableAuthors, pageNumber, pageSize);
        }

        public new List<AccountUnit> GetEmployeeUnit(Expression<Func<per_employee, bool>> exp)
        {
            return context.Set<per_employee>()
                .Where(exp)
                .Select(w => new AccountUnit { UnitType = w.UnitType, AccountingUnit = w.AccountingUnit })
                .Distinct()
                .ToList();
        }

        //public Comparison GetComparison(ComparisonPagingRequest request)
        //{
        //    var search = "";
        //    if (string.IsNullOrEmpty(request.SearchQuery))
        //        search = " 1=1 ";
        //    else
        //    {
        //        if (request.ViewName == "view_check_dept")
        //            search = $" ( AccountingUnit like '%{request.SearchQuery}%' )";
        //        else
        //            search = $" ( AccountingUnit like '%{request.SearchQuery}%' or JobNumber like '%{request.SearchQuery}%' or EmployeeName like '%{request.SearchQuery}%') ";
        //    }


        //    var result = new Comparison();
        //    var sql = $@"SELECT COUNT(*) FROM {request.ViewName} WHERE AllotId = @AllotId and {search}";
        //    result.TotalCount = DapperQuery<int>(sql, new { request.AllotId })?.FirstOrDefault() ?? 0;

        //    sql = $@"SELECT * FROM {request.ViewName} WHERE AllotId = @AllotId and {search} ORDER BY HospitalId,Year,Month,ABS(DIFF) DESC LIMIT {(request.PageIndex - 1) * request.PageSize},{request.PageSize}; ";

        //    result.Datas = DapperQuery<view_check_emp>(sql, new { request.AllotId })?.ToList();
        //    return result;
        //}

        /// <summary>
        /// ԱʵЧȶ
        /// </summary>
        /// <param name="allotId"></param>
        /// <param name="searchQuery"></param>
        /// <returns></returns>
        public DtoModels.Comparison<view_check_emp> CheckEmployeeRealGiveFeeDiff(ComparisonPagingRequest request)
        {
            var queryData = $@"CALL proc_allot_check_emp(@allotId);";
            var checkEmps = DapperQuery<view_check_emp>(queryData, new { allotId = request.AllotId });

            request.SearchQuery = request.SearchQuery?.Clean();
            if (!string.IsNullOrEmpty(request.SearchQuery))
            {
                checkEmps = checkEmps.Where(w => (!string.IsNullOrEmpty(w.UnitType) && w.UnitType.Contains(request.SearchQuery))
                    || (!string.IsNullOrEmpty(w.AccountingUnit) && w.AccountingUnit.Contains(request.SearchQuery))
                    || (!string.IsNullOrEmpty(w.JobNumber) && w.JobNumber.Contains(request.SearchQuery))
                    || (!string.IsNullOrEmpty(w.EmployeeName) && w.EmployeeName.Contains(request.SearchQuery)));
            }

            checkEmps = checkEmps.OrderByDescending(w => Math.Abs(w.Diff ?? 0));
            return new DtoModels.Comparison<view_check_emp>()
            {
                Datas = checkEmps.ToPagedList(request.PageIndex, request.PageSize).Data,
                TotalCount = checkEmps.Count(),
            };
        }

        /// <summary>
        /// ʵЧȶ
        /// </summary>
        public DtoModels.Comparison<view_check_emp> CheckAccountingUnitRealGiveFeeDiff(ComparisonPagingRequest request)
        {
            var queryData = $@"CALL proc_allot_check_dept(@allotId);";
            var checkEmps = DapperQuery<view_check_emp>(queryData, new { allotId = request.AllotId });

            request.SearchQuery = request.SearchQuery?.Clean();
            if (!string.IsNullOrEmpty(request.SearchQuery))
            {
                checkEmps = checkEmps.Where(w => (!string.IsNullOrEmpty(w.UnitType) && w.UnitType.Contains(request.SearchQuery))
                    || (!string.IsNullOrEmpty(w.AccountingUnit) && w.AccountingUnit.Contains(request.SearchQuery))
                    || (!string.IsNullOrEmpty(w.JobNumber) && w.JobNumber.Contains(request.SearchQuery))
                    || (!string.IsNullOrEmpty(w.EmployeeName) && w.EmployeeName.Contains(request.SearchQuery)));
            }

            checkEmps = checkEmps.OrderByDescending(w => Math.Abs(w.Diff ?? 0));
            return new DtoModels.Comparison<view_check_emp>()
            {
                Datas = checkEmps.ToPagedList(request.PageIndex, request.PageSize).Data,
                TotalCount = checkEmps.Count(),
            };
        }

        /// <summary>
        /// ʵЧУ
        /// </summary>
        public DtoModels.Comparison<DeptComparisonTotal> CheckView_check_deptUnitRealGiveFeeDiffTotal(int allotId)
        {
            var queryData = $@"CALL proc_allot_check_dept(@allotId);";
            var checkEmps = DapperQuery<view_check_emp>(queryData, new { allotId });
            var list = checkEmps.Where(w => w.Diff != 0).ToList();
            var datas = list.GroupBy(w => w.UnitType).Select(w => new DeptComparisonTotal
            {
                UnitType = w.Key,
                Count = w.Count(),
                SumFee = w.Sum(p => p.RealGiveFeeCompute),
            }).ToList();

            return new DtoModels.Comparison<DeptComparisonTotal>() { Datas = datas };
        }

        public IDbConnection GetDbConnection()
        {
            return context.Database.GetDbConnection();
        }
    }
}
