﻿using System;
using NPOI.HSSF.Util;
using NPOI.SS.UserModel;

namespace Performance.Services.ExtractExcelService
{
    public class ExcelStyle
    {
        private readonly IWorkbook workbook;

        public ExcelStyle(IWorkbook workbook)
        {
            this.workbook = workbook ?? throw new ArgumentNullException(nameof(IWorkbook));
        }

        public ICellStyle GetEmptyCellStyle()
        {
            return workbook.CreateCellStyle();
        }

        public ICellStyle GetCellStyle()
        {
            ICellStyle cellStyle = workbook.CreateCellStyle();
            SetFont(cellStyle);
            SetBorder(cellStyle);
            SetAlignment(cellStyle);
            return cellStyle;
        }

        public void SetFont(ICellStyle cellStyle, short fontSize = 11, string fontName = "微软雅黑", short fontColor = HSSFColor.Black.Index)
        {
            //字体
            IFont font = workbook.CreateFont();
            font.FontHeightInPoints = fontSize;
            font.FontName = fontName;
            font.Color = fontColor;
            cellStyle.SetFont(font);
        }

        public void SetBorder(ICellStyle cellStyle, BorderStyle borderStyle = BorderStyle.Thin, short borderColor = HSSFColor.Black.Index)
        {
            //边框
            cellStyle.BorderBottom = borderStyle;
            cellStyle.BorderLeft = borderStyle;
            cellStyle.BorderRight = borderStyle;
            cellStyle.BorderTop = borderStyle;

            //边框颜色  
            cellStyle.BottomBorderColor = borderColor;
            cellStyle.TopBorderColor = borderColor;
            cellStyle.LeftBorderColor = borderColor;
            cellStyle.RightBorderColor = borderColor;
        }

        public void SetAlignment(ICellStyle cellStyle, HorizontalAlignment horizontal = HorizontalAlignment.Center, VerticalAlignment vertical = VerticalAlignment.Center)
        {
            //水平居中
            cellStyle.Alignment = horizontal;
            //垂直居中
            cellStyle.VerticalAlignment = vertical;
        }

        public void SetBackgroundColor(ICellStyle cellStyle, short foregroundColor)
        {
            cellStyle.FillForegroundColor = foregroundColor;
            cellStyle.FillPattern = FillPattern.SolidForeground;
        }

        public ICellStyle SetBgkColorAndFormat(ICellStyle cellStyle, StyleType type = StyleType.默认, CellFormat format = CellFormat.默认)
        {
            SetBackgroundColor(cellStyle, type);
            if (format != CellFormat.默认) SetDataFormat(cellStyle, format);
            return cellStyle;
        }

        private void SetBackgroundColor(ICellStyle cellStyle, StyleType type)
        {
            switch (type)
            {
                case StyleType.列头:
                    cellStyle.FillForegroundColor = HSSFColor.Gold.Index;
                    cellStyle.FillPattern = FillPattern.SolidForeground;
                    break;
                case StyleType.系数:
                    cellStyle.FillForegroundColor = HSSFColor.Green.Index;
                    cellStyle.FillPattern = FillPattern.SolidForeground;
                    break;
                case StyleType.数据:
                    cellStyle.FillForegroundColor = HSSFColor.SkyBlue.Index;
                    cellStyle.FillPattern = FillPattern.SolidForeground;
                    break;
                case StyleType.Remove:
                    cellStyle.FillForegroundColor = HSSFColor.Orange.Index;
                    cellStyle.FillPattern = FillPattern.SolidForeground;
                    break;
                case StyleType.默认:
                default:
                    cellStyle.FillForegroundColor = HSSFColor.White.Index;
                    cellStyle.FillPattern = FillPattern.SolidForeground;
                    break;
            }
        }

        private void SetDataFormat(ICellStyle cellStyle, CellFormat format)
        {
            IDataFormat datastyle = workbook.CreateDataFormat();
            switch (format)
            {
                case CellFormat.时间:
                    cellStyle.DataFormat = datastyle.GetFormat("yyyy/mm/dd");
                    break;
                case CellFormat.数字:
                    cellStyle.DataFormat = datastyle.GetFormat("0");
                    break;
                case CellFormat.数字2:
                    cellStyle.DataFormat = datastyle.GetFormat("0.00");
                    break;
                case CellFormat.百分比:
                    cellStyle.DataFormat = datastyle.GetFormat("0%");
                    break;
                case CellFormat.百分比2:
                    cellStyle.DataFormat = datastyle.GetFormat("0.00%");
                    break;
                case CellFormat.默认:
                default:
                    break;
            }
        }
    }
}
