﻿using Performance.DtoModels;

namespace Performance.Services
{
    /// <summary>
    /// 工厂
    /// </summary>
    public class PerSheetDataFactory
    {
        /// <summary>
        /// 构建excel读取
        /// </summary>
        /// <param name="sheetType"></param>
        /// <returns></returns>
        public static IPerSheetDataRead GetDataRead(SheetType sheetType, bool isnew = false)
        {
            IPerSheetDataRead dataread = null;
            switch (sheetType)
            {
                case SheetType.Employee:
                    dataread = new PerSheetDataReadEmployee();
                    break;
                case SheetType.ClinicEmployee:
                    dataread = new PerSheetDataReadClinicEmployee();
                    break;
                case SheetType.Income:
                    if (isnew)
                        dataread = new PerSheetDataReadBillIncome();
                    else
                        dataread = new PerSheetDataReadIncome();
                    break;
                case SheetType.OtherIncome:
                    dataread = new PerSheetDataReadOtherIncome();
                    break;
                case SheetType.Expend:
                    dataread = new PerSheetDataReadExpend();
                    break;
                //case SheetType.Overtime:
                //    dataread = new PerSheetDataReadOvertime();
                //    break;
                case SheetType.Workload:
                    dataread = new PerSheetDataReadWorkload();
                    break;
                case SheetType.AccountBasic:
                    dataread = new PerSheetDataReadDeptAccounting();
                    break;
                case SheetType.SpecialUnit:
                    dataread = new PerSheetDataReadSpecialUnit();
                    break;
                case SheetType.AccountBasicSpecial:
                    dataread = new PerSheetDataReadDeptAccountingSpecial();
                    break;
                case SheetType.AccountExtra:
                    dataread = new PerSheetDataReadAccountExtra();
                    break;

                case SheetType.LogisticsEmployee:
                    dataread = new PerSheetDataReadLogisticsEmployee();  // 行政后勤
                    break;
                case SheetType.PersonExtra:
                    //dataread = new PerSheetDataReadPersonExtra();  // 业务中层行政中高层医院奖罚
                    dataread = new PerSheetDataReadPersonExtra();
                    break;
                case SheetType.AccountDrugAssess:
                    dataread = new PerSheetDataReadAccountExtra();
                    //dataread = new PerSheetDataReadAccountDrugAssess();  // 科室药占比考核
                    break;
                case SheetType.AccountMaterialsAssess:
                    dataread = new PerSheetDataReadAccountExtra();
                    //dataread = new PerSheetDataReadAccountMaterialsAssess();  // 科室材料考核
                    break;
                case SheetType.AccountScoreAverage:
                    dataread = new PerSheetDataReadAccountExtra();
                    break;
                //case SheetType.AccountAdjustLaterOtherFee:
                //    //dataread = new PerSheetDataReadPersonExtra();  // 科室调节后其他绩效
                //    dataread = new PerSheetDataReadAccountExtra();
                //    break;
                case SheetType.PersonAdjustLaterOtherFee:
                    dataread = new PerSheetDataReadPersonExtra();  // 业务中层行政中高层调节后其他绩效
                    break;

                case SheetType.BudgetRatio:
                    dataread = new PerSheetDataReadAccountExtra(); // 预算比例
                    break;
                case SheetType.AssessBeforeOtherFee:
                    dataread = new PerSheetDataReadAccountExtra(); // 科室考核前其他绩效
                    break;
                case SheetType.AccountAdjustLaterOtherFee:
                    dataread = new PerSheetDataReadAccountExtra(); // 科室调节后其他绩效
                    break;
                case SheetType.PersonOtherManagePerforFee:
                    dataread = new PerSheetDataReadPersonExtra(); // 其他管理绩效
                    break;
                case SheetType.PersonAdjustLaterOtherManagePerforFee:
                    dataread = new PerSheetDataReadPersonExtra(); // 调节后其他管理绩效
                    break;
                case SheetType.PersonPostCoefficient:
                    dataread = new PerSheetDataReadPersonExtra(); // 个人岗位系数
                    break;

                case SheetType.WorkloadMedicineProp:
                    dataread = new PerSheetDataReadAccountExtra(); // 药占比系数 
                    break;
                case SheetType.WorkloadCMI:
                    dataread = new PerSheetDataReadAccountExtra(); // CMI系数 
                    break;
                case SheetType.WorkloadIncline:
                    dataread = new PerSheetDataReadAccountExtra(); // 工作量倾斜系数
                    break;
            }
            return dataread;
        }
    }
}