﻿using System.Collections.Generic;
using System.Linq;
using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;

namespace Performance.Services
{
    /// <summary>
    /// 科室奖罚
    /// </summary>
    public class PerSheetDataReadPersonExtra : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 1,
            HeaderLastRowNum = 1,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 2,
            DataFirstCellNum = 5,
            TotalCellNum = 0,
            AccountingUnit = new List<AccountingUnit>
            {
               new AccountingUnit
               {
                    UnitTypeNum = 1,
                    AccountingUnitCellNum = 2,
                    JobCellNum = 3,
                    EmpNameCellNum = 4,
               }
            }
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            var unit = Point.AccountingUnit.First();
            //查询除了 核算单元  科室名称 有效数据列头位置
            var vhead = perHeader.Where(t => t.PointCell != unit.UnitTypeNum && t.PointCell != unit.AccountingUnitCellNum && t.PointCell != unit.JobCellNum && t.PointCell != unit.EmpNameCellNum).OrderBy(t => t.PointCell);
            //var vhead = perHeader.OrderBy(t => t.PointCell);

            for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
            {
                var row = sheet.GetRow(r);
                if (row == null) continue;

                for (int c = 0; c < vhead.Count(); c++)
                {
                    var athead = vhead.ElementAt(c);
                    //var cellValue = NopiSevice.GetCellValue(row.GetCell(athead.PointCell));
                    var cellValue = ConvertHelper.ToDecimalOrNull(row.GetCell(athead.PointCell).GetValue());
                    if (!cellValue.HasValue || cellValue.Value == 0)
                        continue;

                    PerData data = new PerData
                    {
                        RowNumber = r,
                        SignID = athead.SignID,
                        UnitType = row.GetCell(unit.UnitTypeNum.Value).GetValue(),
                        AccountingUnit = row.GetCell(unit.AccountingUnitCellNum.Value).GetValue(),
                        TypeName = athead?.CellValue,
                        CellValue = cellValue,
                        //Annotation = row.GetCell(athead.PointCell)?.CellComment?.String?.String,
                        FactorValue = 1,
                        IsFactor = true,
                    };
                    if (Point.TotalCellNum.HasValue && athead.PointCell == Point.TotalCellNum)
                        data.IsTotal = 1;
                    if (unit.DeptCellNum.HasValue)
                        data.Department = row.GetCell(unit.DeptCellNum.Value).GetValue();
                    if (unit.EmpNameCellNum.HasValue)
                        data.EmployeeName = row.GetCell(unit.EmpNameCellNum.Value).GetValue();
                    if (unit.JobCellNum.HasValue)
                        data.JobNumber = row.GetCell(unit.JobCellNum.Value).GetValue();

                    if (string.IsNullOrEmpty(data.AccountingUnit) && string.IsNullOrEmpty(data.Department))
                        continue;
                    dataList.Add(data);
                }
            }

            return dataList;
        }
    }
}
