﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using Dapper;
using Microsoft.Extensions.Configuration;
using MySql.Data.MySqlClient;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Repository;

namespace Performance.Services
{
    public class TaskService : IAutoInjection
    {
        private readonly IConfiguration _configuration;
        private readonly PerforBgtaskRepository _taskRepository;

        public TaskService(IConfiguration configuration, PerforBgtaskRepository taskRepository)
        {
            _configuration = configuration;
            _taskRepository = taskRepository;
        }

        /// <summary>
        /// 默认返回 最近10小时的任务
        /// </summary> 
        /// <param name="hours"></param>
        /// <returns></returns>
        public List<bg_task> GetTasks(int hours = -10)
        {
            var connectionString = _configuration.GetValue("AppConnection:PerformanceConnectionString", "");
            using var conn = new MySqlConnection(connectionString);
            if (conn.State != ConnectionState.Open) conn.Open();

            var sql = @"SELECT * FROM bg_task WHERE CreateTime > DATE_ADD(CURRENT_TIMESTAMP(), INTERVAL CAST(@hours AS signed) hour);";
            var tasks = conn.Query<bg_task>(sql, new { hours }).ToList();
            return tasks;
        }

        public bool Add(Background.JobType type, string argument = "")
        {
            return _taskRepository.Add(new bg_task
            {
                Name = type.ToString(),
                JobType = (int)type,
                CreateTime = DateTime.Now,
                Argument = argument,
                Status = (int)Background.Status.等待,
                Remark = $"{type} - {Background.Status.等待}"
            });
        }

        public bool Update(int taskId, Background.Status status, string remark = "", double seconds = 0)
        {
            var task = _taskRepository.GetEntity(w => w.ID == taskId);
            if (task == null) return false;

            task.Status = (int)status;
            if (status == Background.Status.执行中)
                task.BeginTime = DateTime.Now;
            task.ElapsedTime = seconds;
            task.Remark = $"{(Background.JobType)task.JobType} - {status} {remark}";
            if (status == Background.Status.完成 || status == Background.Status.失败 || status == Background.Status.超时)
                task.EndTime = DateTime.Now;

            return _taskRepository.Update(task);
        }
    }
}
