﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.Services.ExtractExcelService
{
    /// <summary>
    /// 抽取结果（转换核算单元后）
    /// </summary>
    public class ExtractTransDto
    {
        /// <summary>
        /// 医生姓名
        /// </summary>
        public string DoctorName { get; set; }

        /// <summary>
        /// 医生工号
        /// </summary>
        public string PersonnelNumber { get; set; }

        /// <summary>
        /// 科室
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// 费用类别
        /// </summary>
        public string Category { get; set; }

        /// <summary>
        /// 费用
        /// </summary>
        public decimal? Value { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string SheetName { get; set; }

        /// <summary>
        /// 核算单元（门诊医生）
        /// </summary>
        public string OutDoctorAccounting { get; set; }

        /// <summary>
        /// 核算单元（门诊护理）
        /// </summary>
        public string OutNurseAccounting { get; set; }

        /// <summary>
        /// 核算单元（门诊医技）
        /// </summary>
        public string OutTechnicAccounting { get; set; }

        /// <summary>
        /// 核算单元（住院医生）
        /// </summary>
        public string InpatDoctorAccounting { get; set; }

        /// <summary>
        /// 核算单元（住院护理）
        /// </summary>
        public string InpatNurseAccounting { get; set; }

        /// <summary>
        /// 核算单元（住院医技）
        /// </summary>
        public string InpatTechnicAccounting { get; set; }
    }
}
