//-----------------------------------------------------------------------
// <copyright file=" im_employee_clinic.cs">
// * FileName: .cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 
    /// </summary>
    [Table("im_employee_clinic")]
    public class im_employee_clinic
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int ID { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> AllotID { get; set; }

        /// <summary>
        /// sheet页id
        /// </summary>
        public Nullable<int> SheetID { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> RowNumber { get; set; }

        /// <summary>
        /// 核算单元分类
        /// </summary>
        public string UnitType { get; set; }

        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 科室名称
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// 人员工号
        /// </summary>
        public string PersonnelNumber { get; set; }

        /// <summary>
        /// 医生姓名
        /// </summary>
        public string DoctorName { get; set; }

        /// <summary>
        /// 职称
        /// </summary>
        public string JobTitle { get; set; }

        /// <summary>
        /// 基础绩效系数
        /// </summary>
        public Nullable<decimal> Basics { get; set; }

        /// <summary>
        /// 实际人均绩效
        /// </summary>
        public Nullable<decimal> FitPeopleValue { get; set; }

        /// <summary>
        /// 岗位系数
        /// </summary>
        public Nullable<decimal> PostCoefficient { get; set; }

        /// <summary>
        /// 效率绩效人数
        /// </summary>
        public Nullable<decimal> PermanentStaff { get; set; }

        /// <summary>
        /// 效率绩效系数
        /// </summary>
        public Nullable<decimal> Efficiency { get; set; }

        /// <summary>
        /// 规模绩效系数
        /// </summary>
        public Nullable<decimal> Scale { get; set; }

        /// <summary>
        /// 管理绩效发放系数
        /// </summary>
        public Nullable<decimal> Management { get; set; }

        /// <summary>
        /// 其他管理绩效
        /// </summary>
        public Nullable<decimal> OtherManagePerfor { get; set; }

        /// <summary>
        /// 考核得分率
        /// </summary>
        public Nullable<decimal> ScoreAverageRate { get; set; }

        /// <summary>
        /// 出勤率
        /// </summary>
        public Nullable<decimal> Attendance { get; set; }

        /// <summary>
        /// 核算单元医生数
        /// </summary>
        public Nullable<int> PeopleNumber { get; set; }

        /// <summary>
        /// 工作量绩效
        /// </summary>
        public Nullable<decimal> Workload { get; set; }

        /// <summary>
        /// 其他绩效
        /// </summary>
        public Nullable<decimal> OtherPerfor { get; set; }

        /// <summary>
        /// 医院奖罚
        /// </summary>
        public Nullable<decimal> Punishment { get; set; }

        /// <summary>
        /// 调节系数
        /// </summary>
        public Nullable<decimal> Adjust { get; set; }

        /// <summary>
        /// 发放系数
        /// </summary>
        public Nullable<decimal> Grant { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<DateTime> UpdateDate { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> UpdateUser { get; set; }
        /// <summary>
        /// 考核前其他绩效
        /// </summary>
        public Nullable<decimal> AssessBeforeOtherFee { get; set; }
        /// <summary>
        /// 考核后其他绩效
        /// </summary>
        public Nullable<decimal> AssessLaterOtherFee { get; set; }
        /// <summary>
        /// 调节后其他绩效
        /// </summary>
        public Nullable<decimal> AdjustLaterOtherFee { get; set; }
    }
}
