//-----------------------------------------------------------------------
// <copyright file=" per_dept_dic.cs">
// * FileName: per_dept_dic.cs
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.Collections.Generic;
using Performance.EntityModels;

namespace Performance.Repository
{
    /// <summary>
    /// per_dept_dic Repository
    /// </summary>
    public partial class PerforPerdeptdicRepository : PerforRepository<per_dept_dic>
    {
        public PerforPerdeptdicRepository(PerformanceDbContext context) : base(context)
        {
        }

        public IEnumerable<per_dept_dic> GetAccountBasicAccountingUnit(int hospitalId)
        {
            string sql = @"select * from
(
	select distinct
		unittype,
		ifnull
		(
			max(case when source = '' then accountingunit end),
			max(case when source = 'סԺ' then accountingunit end)
		) accountingunit
	from per_dept_dic
	where hospitalid = @hospitalId
	group by unittype,department,hisdeptname
) t
where ifnull(accountingunit, '')<>''
order by unittype,accountingunit;";
            return DapperQuery<per_dept_dic>(sql, new { hospitalId });
        }
    }
}
