﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.EntityModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services.ExtractExcelService.SheetDataWrite
{
    public class AccountBasicDataWrite : ISheetDataWrite
    {
        public void WriteCollectData(ISheet sheet, PerSheetPoint point, SheetType sheetType, ExcelStyle style, List<collect_data> collects)
        {
        }

        public void WriteSheetData(ISheet sheet, PerSheetPoint point, SheetType sheetType, ExcelStyle style, object data, Dictionary<ExDataDict, object> exdict = null)
        {
            if (data is List<per_dept_dic> departments && departments.Any())
            {
                int dataFirstRowNum = point.DataFirstRowNum.Value;

                var accountingUnits = departments.Select(t => new
                {
                    UnitType = t.UnitType.NoBlank(),
                    AccountingUnit = t.AccountingUnit.NoBlank()
                }).ToList();

                var tuples = new List<Account>();

                for (int i = point.DataFirstRowNum.Value; i < sheet.LastRowNum + 1; i++)
                {
                    var row = sheet.GetRow(i);
                    if (row == null) continue;

                    var unittype = row.GetCell(point.DataFirstCellNum.Value - 2).GetDecodeEscapes();
                    var accountingunit = row.GetCell(point.DataFirstCellNum.Value - 2).GetDecodeEscapes();

                    if (!tuples.Any())
                        tuples.Add(new Account(unittype, i, i));
                    else
                    {
                        var last = tuples.Last();
                        if (last.UnitType == unittype)
                            last.EndIndex = i;
                        else
                            tuples.Add(new Account(unittype, i, i));
                    }

                    var account = accountingUnits.FirstOrDefault(t => t.AccountingUnit == accountingunit && t.UnitType == unittype);
                    if (account != null) accountingUnits.Remove(account);
                }

                if (accountingUnits == null || !accountingUnits.Any()) return;

                int number = 0;
                foreach (var unitType in tuples.Select(t => t.UnitType).Distinct())
                {
                }
            }
        }
    }

    public class Account
    {
        public Account()
        {
        }

        public Account(string unitType, int beginIndex, int endIndex)
        {
            UnitType = unitType;
            BeginIndex = beginIndex;
            EndIndex = endIndex;
        }

        public string UnitType { get; set; }

        public int BeginIndex { get; set; }

        public int EndIndex { get; set; }
    }
}
