﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.EntityModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services.ExtractExcelService.SheetDataWrite
{
    public class EmployeeDataWrite : ISheetDataWrite
    {
        public void WriteCollectData(ISheet sheet, PerSheetPoint point, SheetType sheetType, ExcelStyle style, List<collect_data> collects)
        {

        }

        public void WriteSheetData(ISheet sheet, PerSheetPoint point, SheetType sheetType, ExcelStyle style, object data, Dictionary<ExDataDict, object> exdict)
        {
            if (data is List<per_employee> employees && employees.Any(t => accountingUnits.Contains(t.UnitType)))
            {
                int dataFirstRowNum = point.DataFirstRowNum.Value;

                var columns = sheet.CreateRow(point.HeaderFirstRowNum.Value).GetCellValues();

                ClearSheetPartialData(sheet, employees, columns, ref dataFirstRowNum);

                foreach (var employee in employees)
                {
                    var row = sheet.GetOrCreate(dataFirstRowNum);
                    for (int cellIndex = 0; cellIndex < columns.Count(); cellIndex++)
                    {
                        var column = columns[cellIndex];
                        if (string.IsNullOrEmpty(column) || !employeeDict.ContainsKey(column)) continue;

                        var cell = row.GetOrCreate(cellIndex);
                        cell.SetCellOValue(employeeDict[column].Invoke(employee));
                    }
                    dataFirstRowNum++;
                }
            }
        }

        private void ClearSheetPartialData(ISheet sheet, List<per_employee> employees, List<string> columns, ref int dataFirstRowNum)
        {
            var pairs = new Dictionary<string, int>();
            foreach (var key in new string[] { "核算单元", "人员工号", "医生姓名" })
            {
                if (!pairs.ContainsKey(key) && columns.Contains(key))
                    pairs.Add(key, columns.IndexOf(key));
            }

            var clearDict = new Dictionary<string, int>();
            foreach (var key in new string[] { "出勤率" })
            {
                if (!clearDict.ContainsKey(key) && columns.Contains(key))
                    clearDict.Add(key, columns.IndexOf(key));
            }

            for (int rowIndex = dataFirstRowNum; rowIndex < sheet.LastRowNum; rowIndex++)
            {
                var row = sheet.GetRow(dataFirstRowNum);

                string accountingUnit = row.GetOrCreate(pairs["核算单元"]).GetDecodeEscapes();
                string personnel = row.GetOrCreate(pairs["人员工号"]).GetDecodeEscapes();
                string doctorName = row.GetOrCreate(pairs["医生姓名"]).GetDecodeEscapes();

                var employee = employees.FirstOrDefault(t => t.AccountingUnit == accountingUnit && t.PersonnelNumber == personnel && t.DoctorName == doctorName);
                if (employee == null)
                {

                }
                else
                {
                    foreach (var clear in clearDict)
                    {
                        if (clear.Value < 0) return;
                        var cell = row.GetOrCreate(clear.Value);
                        if (cell.CellType != CellType.Formula) cell.SetCellValue("");
                    }
                    employees.Remove(employee);
                }
                if (rowIndex > dataFirstRowNum) dataFirstRowNum = rowIndex + 1;
            }
        }

        private readonly string[] accountingUnits = new string[] { AccountUnitType.行政高层.ToString(), AccountUnitType.行政中层.ToString(), AccountUnitType.行政工勤.ToString() };

        private readonly Dictionary<string, Func<per_employee, object>> employeeDict = new Dictionary<string, Func<per_employee, object>>
        {
            {  "人员分类", (t) => t.UnitType },
            {  "核算单元", (t) => t.AccountingUnit },
            {  "人员工号", (t) => t.PersonnelNumber },
            {  "医生姓名", (t) => t.DoctorName },
            {  "参加工作时间", (t) => t.WorkTime },
            {  "出勤率", (t) => t.Attendance },
        };
    }
}
