﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class ComputeResult
    {
        /// <summary>
        /// 科室类别(例如 医技科室 临床科室 其他科室)
        /// </summary>
        public string AccountType { get; set; }
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 绩效基数核算参考对象
        /// </summary>
        public string FitPeople { get; set; }

        /// <summary>
        /// 绩效基础核算参考值
        /// </summary>
        public Nullable<decimal> FitPeopleValue { get; set; }

        /// <summary>
        /// 绩效基数核算参考对象取值比例（如临床科室护士*95%）
        /// </summary>
        public Nullable<decimal> FitPeopleRatio { get; set; }

        /// <summary>
        /// 人员姓名
        /// </summary>
        public string EmployeeName { get; set; }

        /// <summary>
        /// 绩效合计 考核前(来自科室经济测算表)
        /// </summary>
        public Nullable<decimal> PerforTotal { get; set; }

        /// <summary>
        /// 核算单元医生数量(来自科室经济测算表)
        /// </summary>
        public Nullable<decimal> Number { get; set; }

        /// <summary>
        /// 人均绩效(来自科室经济测算表)
        /// </summary>
        public Nullable<decimal> Avg { get; set; }

        /// <summary>
        /// 效率绩效(需计算)
        /// </summary>
        public Nullable<decimal> Efficiency { get; set; }

        /// <summary>
        /// 规模绩效(需计算)
        /// </summary>
        public Nullable<decimal> Scale { get; set; }

        /// <summary>
        /// 岗位系数
        /// </summary>
        public Nullable<decimal> PostCoefficient { get; set; }

        /// <summary>
        /// 发放系数(来自人员名单)
        /// </summary>
        public Nullable<decimal> Grant { get; set; }

        /// <summary>
        /// 应发管理绩效(需计算)
        /// </summary>
        public Nullable<decimal> ShouldGiveFee { get; set; }

        /// <summary>
        /// 绩效合计 考核前(需计算)
        /// </summary>
        public Nullable<decimal> PerforSumFee { get; set; }

        /// <summary>
        /// 考核前其他绩效
        /// </summary>
        public Nullable<decimal> AssessBeforeOtherFee { get; set; }

        /// <summary>
        /// 考核得分率
        /// </summary>
        public Nullable<decimal> ScoreAverageRate { get; set; }

        /// <summary>
        /// 考核后其他绩效
        /// </summary>
        public Nullable<decimal> AssessLaterOtherFee { get; set; }

        /// <summary>
        /// 调节后其他绩效
        /// </summary>
        public Nullable<decimal> AdjustLaterOtherFee { get; set; }

        /// <summary>
        /// 出勤率(来自人员名单)
        /// </summary>
        public Nullable<decimal> Attendance { get; set; }

        /// <summary>
        /// 医院奖罚 来自5.2
        /// </summary>
        public Nullable<decimal> Punishment { get; set; }

        /// <summary>
        /// 其他管理绩效
        /// </summary>
        public Nullable<decimal> OtherManagePerfor { get; set; }

        /// <summary>
        /// 其他绩效(来自人员名单)
        /// </summary>
        public Nullable<decimal> OtherPerfor { get; set; }

        /// <summary>
        /// 应发绩效 考核前(需计算)
        /// </summary>
        public Nullable<decimal> GiveFee { get; set; }

        /// <summary>
        /// 参考基数专用绩效合计
        /// </summary>
        public Nullable<decimal> BaiscNormPerforTotal { get; set; }

        ///// <summary>
        ///// 参加工作时间(来自人员名单)
        ///// </summary>
        //public Nullable<DateTime> WorkTime { get; set; }

        /// <summary>
        /// 绩效基础金额(计算)
        /// </summary>
        public Nullable<decimal> BaiscNormValue { get; set; }

        ///// <summary>
        ///// 年资系数(来自人员名单)
        ///// </summary>
        //public Nullable<decimal> WorkYear { get; set; }

        /// <summary>
        /// 实发绩效
        /// </summary>
        public decimal? RealGiveFee { get; set; }

        /// <summary>
        /// 职称
        /// </summary>
        public string JobTitle { get; set; }

        /// <summary>
        /// 调节系数
        /// </summary>
        public decimal? Adjust { get; set; }

        public string UnitType { get; set; }

        public string Remark { get; set; }

        /// <summary>
        /// 工号
        /// </summary>
        public string JobNumber { get; set; }

        ///// <summary>
        ///// 工作量绩效
        ///// </summary>
        //public decimal? Workload { get; set; }

        /// <summary>
        /// 科主任/护士长人数
        /// </summary>
        public Nullable<decimal> ManagerNumber { get; set; }

        /// <summary>
        /// 核算单元人员数量
        /// </summary>
        public Nullable<decimal> MedicalNumber { get; set; }

        /// <summary>
        /// 效率绩效人数
        /// </summary>
        public Nullable<decimal> PermanentStaff { get; set; }

        /// <summary>
        /// 夜班费
        /// </summary>
        public Nullable<decimal> NightWorkPerfor { get; set; }
    }
}
