﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class PerDataLogisticsEmployee : IPerData
    {
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 绩效基数核算参考对象
        /// </summary>
        public string FitPeople { get; set; }

        /// <summary>
        /// 绩效基础核算参考值
        /// </summary>
        public Nullable<decimal> FitPeopleValue { get; set; }

        /// <summary>
        /// 绩效基数核算参考对象取值比例（如临床科室护士*95%）
        /// </summary>
        public Nullable<decimal> FitPeopleRatio { get; set; }

        /// <summary>
        /// 科室类别(例如 医技科室 临床科室 其他科室)
        /// </summary>
        public string AccountType { get; set; }

        /// <summary>
        /// 人员工号
        /// </summary>
        public string PersonnelNumber { get; set; }

        /// <summary>
        /// 姓名
        /// </summary>
        public string DoctorName { get; set; }

        /// <summary>
        /// 职务分类
        /// </summary>
        public string JobTitle { get; set; }

        /// <summary>
        /// 岗位系数
        /// </summary>
        public Nullable<decimal> PostCoefficient { get; set; }

        /// <summary>
        /// 出勤率
        /// </summary>
        public Nullable<decimal> Attendance { get; set; }

        /// <summary>
        /// 其他绩效
        /// </summary>
        public Nullable<decimal> OthePerfor { get; set; }

        /// <summary>
        /// 调节后其他绩效
        /// </summary>
        public Nullable<decimal> AdjustLaterOtherFee { get; set; }

        /// <summary>
        /// 行号
        /// </summary>
        public int RowNumber { get; set; }
    }
}

