﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class AprAmountAuditRequest
    {
        /// <summary> 二次绩效Id </summary>
        public int[] Id { get; set; }

        /// <summary> 审核结果 1、审核通过 2、驳回 </summary>
        public int IsPass { get; set; }

        /// <summary> 备注 </summary>
        public string Remark { get; set; }
    }
    public class AprAmountAuditRequestValidator : AbstractValidator<AprAmountAuditRequest>
    {
        public AprAmountAuditRequestValidator()
        {
            RuleFor(x => x.IsPass).NotNull().NotEmpty().InclusiveBetween(1, 2);
        }
    }
}
