﻿using Microsoft.AspNetCore.SignalR;
using Microsoft.Extensions.Logging;
using Microsoft.Extensions.Options;
using Performance.DtoModels.AppSettings;
using Performance.Infrastructure;
using Performance.Repository;
using System;

namespace Performance.Services
{
    public class LogManageService : IAutoInjection
    {
        private readonly ILogger<LogManageService> logger;
        private readonly IHubContext<AllotLogHub> hubContext;
        private readonly WebapiUrl url;
        private PerforLogdbugRepository logdbug;

        public LogManageService(
            ILogger<LogManageService> logger,
            IHubContext<AllotLogHub> hubContext,
            IOptions<WebapiUrl> url,
            PerforLogdbugRepository logdbug)
        {
            this.logger = logger;
            this.hubContext = hubContext;
            this.url = url.Value;
            this.logdbug = logdbug;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="tag">标签</param>
        /// <param name="message">内容</param>
        /// <param name="level">等级1、信息（info）2、警告（warn）3、错误（error）4、异常（exception）5、成功（success）</param>
        /// <param name="allotId">绩效Id</param>
        /// <param name="method">方法名称</param>
        public void WriteMsg(string tag, string message, int level, int allotId, string method, bool isDebug = false)
        {
            logger.LogInformation($"method:{method};tag:{tag}; message:{message}; level:{level}");
            hubContext.Clients.Group(allotId.ToString()).SendAsync(method, tag, message, level);
            if (isDebug)
            {
                logdbug.Add(allotId, tag, message, level, 1);
            }
        }

        /// <summary>
        /// 抽取进度
        /// </summary>
        /// <param name="groupName"></param>
        /// <param name="ratio"></param>
        /// <param name="level">等级1、信息（info）2、警告（warn）3、错误（error）4、异常（exception）5、成功（success）</param>
        /// <param name="success"></param>
        public void Schedule(string groupName, decimal ratio, int level)
        {
            ratio = Math.Round(ratio);

            if (level != 5 && ratio > 100) ratio = 99;

            if (level == 5 && ratio != 100) ratio = 100;

            hubContext.Clients.Group(groupName).SendAsync("Schedule", ratio, level);
        }

        /// <summary>
        /// 抽取日志
        /// </summary>
        /// <param name="groupName"></param>
        /// <param name="tag"></param>
        /// <param name="message"></param>
        /// <param name="level">等级1、信息（info）2、警告（warn）3、错误（error）4、异常（exception）5、成功（success）</param>
        public void ExtractLog(string groupName, string tag, string message, int level)
        {

            hubContext.Clients.Group(groupName).SendAsync("ExtractLog", tag, message, level);
        }

        public void ReturnTheLog(int allotId, string groupName, int type, string tag, object message, int level = 1)
        {
            try
            {
                var http = url.ImportFile + $"/template/returnlog?type={type}&tag={tag}&message={message}&level={level}&groupName={groupName}";
                //logger.LogInformation("发送日志：" + http);
                logdbug.Add(allotId, tag, message.ToString(), level, type);
                HttpHelper.HttpPost(http);
            }
            catch (Exception ex)
            {
                logger.LogInformation("发送日志失败：" + ex.ToString());
            }
        }

        public bool ClearExtractLog(int allotId)
        {
            return logdbug.ClearExtractLog(allotId);
        }
    }
}
