﻿using FluentValidation;
using System;

namespace Performance.DtoModels
{
    public class CofAgainRequest
    {
        public int ID { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int AllotID { get; set; }

        /// <summary>
        /// 科室
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// 1 职称绩效 2 工作量绩效 3 满勤天数
        /// </summary>
        public int Type { get; set; }

        /// <summary>
        /// 参数名称
        /// </summary>
        public string TypeName { get; set; }

        /// <summary>
        /// 参数值
        /// </summary>
        public Nullable<decimal> Value { get; set; }

        public int CurrentPage { get; set; } = 0;
        public int PageSize { get; set; } = 0;

        public class CofAgainRequestValidator : AbstractValidator<CofAgainRequest>
        {
            public CofAgainRequestValidator()
            {
                RuleSet("Select", () =>
                {
                    RuleFor(x => x.AllotID).NotNull().NotEmpty().GreaterThan(0);
                });

                RuleSet("Insert", () =>
                {
                    RuleFor(x => x.AllotID).NotNull().GreaterThan(0);
                });

                RuleSet("Update", () =>
                {
                    RuleFor(x => x.ID).NotNull().GreaterThan(0);
                });

                RuleSet("Delete", () =>
                {
                    RuleFor(x => x.ID).NotNull().GreaterThan(0);
                });
            }
        }
    }
}
