﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace Performance.DtoModels
{
    /// <summary> 验证码类型 </summary>
    public enum SmsCodeType
    {
        [Description("登录")]
        Login = 1,
        [Description("其他")]
        Other = 2,
    }

    /// <summary> 用户状态 </summary>
    public enum States
    {
        [Description("启用")]
        Enabled = 1,
        [Description("禁用")]
        Disabled = 2,
    }

    /// <summary> 提取数据使用模板 </summary>
    public enum UseTemplate
    {
        /// <summary> 上次绩效 </summary>
        [Description("上次绩效")]
        LastAllot = 1,
        /// <summary> 配置模板 </summary>
        [Description("配置模板")]
        Config = 2,
    }

    /// <summary> 提取数据使用模板 </summary>
    public enum DbSrouceType
    {
        /// <summary> 标准库 </summary>
        [Description("标准库")]
        Standard = 1,
        /// <summary> 绩效库 </summary>
        [Description("绩效库")]
        Performance = 2,
    }


    public enum AgWorkloadType
    {
        /// <summary>
        /// 核算前奖励
        /// </summary>
        PreAccountingReward = -2,
        /// <summary>
        /// 单项奖励
        /// </summary>
        SingleAwards = -1,
        /// <summary>
        /// 工作量
        /// </summary>
        Workload = 0,
    }
    public enum DataFormat
    {
        /// <summary> 普通格式 </summary>
        普通格式,
        /// <summary> 小数 </summary>
        小数,
        /// <summary> 小数 </summary>
        小数1,
        /// <summary> 整数 </summary>
        整数,
        /// <summary> 货币 </summary>
        货币,
        /// <summary> 百分比 </summary>
        百分比,
        /// <summary> 科学计数 </summary>
        科学计数,
        /// <summary> 分数 </summary>
        分数,
        /// <summary> 日期 </summary>
        日期YYYYMMDD
    }

    public class Background
    {
        public enum JobType
        {
            生成测算表 = 1,
            提取数据 = 2,
            报表 = 3,
            自定义抽取 = 4,
            每日汇报表汇总 = 5,
        }
        public enum Status
        {
            等待 = 1,
            执行中 = 2,
            完成 = 3,
            失败 = 10,
            无效 = 88,
            超时 = 99,
        }
    }

    public class Attendance
    {
        public enum Type
        {
            开始,
            调入,
            结束,
        }
        public enum Deduction
        {
            核减 = 1,
            不核减 = 2,
        }
    }

    public class SecondAllot
    {
        public enum Status
        {
            未提交 = 1,
            等待审核 = 2,
            审核通过 = 3,
            驳回 = 4,
        }
    }

    public class EnumResult
    {
        public enum AuditGather
        {
            未审核 = 0,
            未通过 = 1,
            已通过 = 2,
        }
        public enum FromSource
        {
            提取 = 0,
            录入 = 1,
        }
    }
}
