﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    /// <summary>
    /// title value
    /// </summary>
    public class TitleValue<TV, TS>
    {
        /// <summary>
        /// Title
        /// </summary>
        public string Title { get; set; }
        /// <summary>
        /// Value
        /// </summary>
        public TV Value { get; set; }
        /// <summary>
        /// 存储数据
        /// </summary>
        public TS State { get; set; }
    }
    /// <summary>
    /// title value
    /// </summary>
    public class TitleValue<T> : TitleValue<T, int>
    {
    }
    /// <summary>
    /// title value
    /// </summary>
    public class TitleValue : TitleValue<string>
    {
        public TitleValue()
        {
        }
        public TitleValue(string title, string value)
            : this(title, value, 2)
        {
        }
        public TitleValue(string title, string value, int state)
        {
            this.Title = title;
            this.Value = value;
            this.State = state;
        }
    }
}
