﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;

namespace Performance.Infrastructure
{
    public static class ReflectionHelper
    {
        /// <summary>
        /// 获取实现了接口的所有实例
        /// </summary>
        /// <typeparam name="TInterface">接口类型</typeparam>
        /// <param name="assembly">在该程序集中查找</param>
        public static List<TInterface> GetInstances<TInterface>(Assembly assembly)
        {
            var typeInterface = typeof(TInterface);
            return assembly.GetTypes()
                .Where(t => typeInterface.GetTypeInfo().IsAssignableFrom(t) && t != typeInterface && t.GetTypeInfo().IsAbstract == false)
                .Select(t => (TInterface)Activator.CreateInstance(t)).ToList();
        }

        /// <summary>
        /// 获取实现了接口的类型
        /// </summary>
        /// <typeparam name="TInterface">接口类型</typeparam>
        /// <param name="assembly">在该程序集中查找</param>
        public static List<Type> GetClassType<TInterface>(Assembly assembly)
        {
            var typeInterface = typeof(TInterface);
            return assembly.GetTypes()
                .Where(t => typeInterface.GetTypeInfo().IsAssignableFrom(t) && t != typeInterface && t.GetTypeInfo().IsAbstract == false).ToList();
        }

    }
}
