﻿using Dapper;
using MassTransit;
using Microsoft.Extensions.Options;
using MySql.Data.MySqlClient;
using Performance.DtoModels;
using Performance.DtoModels.AppSettings;
using Performance.EntityModels;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Threading.Tasks;

namespace Performance.Services
{
    public class DapperService : IAutoInjection
    {
        private readonly IOptions<AppConnection> _options;

        public DapperService(IOptions<AppConnection> options)
        {
            _options = options;
        }

        #region 数据静态存储
        /// <summary>
        /// 数据静态存储
        /// </summary>
        /// <param name="allotId"></param>
        /// <returns></returns>
        public void FreezeAllotSync(int allotId)
        {
            Task.Factory.StartNew(() => FreezeAllot(allotId));
        }

        /// <summary>
        /// 数据静态存储
        /// </summary>
        /// <param name="allotId"></param>
        /// <returns></returns>
        public void FreezeAllot(int allotId)
        {
            try
            {
                int i = 0;
                do
                {
                    HanderFreeze(allotId);
                    i++;
                } while (QueryDiff(allotId) < -50 && i <= 3);
            }
            catch
            {
            }

            void HanderFreeze(int allotId)
            {
                using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
                {
                    if (connection.State != ConnectionState.Open) connection.Open();
                    string sql = $@"call proc_freeze_allot({allotId})";
                    connection.Execute(sql, commandTimeout: 60 * 60);
                }
            }

            decimal QueryDiff(int allotId)
            {
                using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
                {
                    if (connection.State != ConnectionState.Open) connection.Open();
                    string sql = $@"SELECT Diff FROM view_allot_result_diff WHERE AllotID = @allotId LIMIT 1";
                    return connection.QuerySingle<decimal>(sql, new { allotId }, commandTimeout: 60 * 60);
                }
            }
        }
        #endregion

        #region 二次分配模板修复
        /// <summary>
        /// 二次分配模板修复
        /// </summary>
        /// <param name="allotId"></param>
        public void SecondUseTempRestoreSync()
        {
            Task.Factory.StartNew(() =>
            {
                using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
                {
                    if (connection.State != ConnectionState.Open) connection.Open();
                    try
                    {
                        string sql = $@"call proc_second_restore()";
                        connection.Execute(sql, commandTimeout: 60 * 60);
                    }
                    catch (Exception)
                    {
                        throw;
                    }
                }
            });
        }
        #endregion

        #region 清理无效绩效数据
        /// <summary>
        /// 清理无效绩效数据
        /// </summary>
        /// <param name="allotId"></param>
        public void ClearAllotSync()
        {
            Task.Factory.StartNew(() =>
            {
                using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
                {
                    if (connection.State != ConnectionState.Open) connection.Open();
                    try
                    {
                        string sql = $@"call proc_clear_allot()";
                        connection.Execute(sql, commandTimeout: 60 * 60);
                    }
                    catch (Exception)
                    {
                        throw;
                    }
                }
            });
        }
        #endregion

        public void SyncDataToResult(int allotId)
        {
            using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
            {
                if (connection.State != ConnectionState.Open) connection.Open();
                try
                {
                    string sql = $@"call proc_sync_datatoresult({allotId})";
                    connection.Execute(sql, commandTimeout: 60 * 60);
                }
                catch (Exception)
                {
                    throw;
                }
            }
        }
        public void PerEmployeeBackup(int allotId)
        {
            using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
            {
                if (connection.State != ConnectionState.Open) connection.Open();
                try
                {
                    string sql = $@"call proc_per_employee_backup({allotId})";
                    connection.Execute(sql, commandTimeout: 60 * 60);
                }
                catch (Exception)
                {
                    throw;
                }
            }
        }

        #region 数据提取

        public IEnumerable<per_dept_dic> GetAccountBasicAccountingUnit(int hospitalId)
        {
            using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
            {
                if (connection.State != ConnectionState.Open) connection.Open();
                try
                {
                    string sql = @"select * from
(
	select distinct
		unittype,
		ifnull
		(
			max(case when source = '门诊' then accountingunit end),
			max(case when source = '住院' then accountingunit end)
		) accountingunit
	from per_dept_dic
	where hospitalid = @hospitalId
	group by unittype,department,hisdeptname
) t
where ifnull(accountingunit, '无')<>'无'
order by unittype,accountingunit;";
                    return connection.Query<per_dept_dic>(sql, new { hospitalId }, commandTimeout: 60 * 60);
                }
                catch (Exception)
                {
                    throw;
                }
            }
        }

        public IEnumerable<DeptdicResponse> GetDepartments(int allotId)
        {
            using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
            {
                if (connection.State != ConnectionState.Open) connection.Open();
                try
                {
                    var depts = connection.Query<per_dept_dic>("select * from per_dept_dic where allotid = @allotid", new { allotId }, commandTimeout: 60 * 60);
                    if (depts == null || !depts.Any()) return null;

                    var allot = connection.QueryFirstOrDefault<per_allot>("select * from per_allot where id = @allotid", new { allotId }, commandTimeout: 60 * 60);
                    if (allot == null || !depts.Any()) return null;

                    Deptdic GetDeptdic(List<per_dept_dic> dics, string department, string hISDeptName, UnitType unitType, string source = "")
                    {
                        var dic = dics.FirstOrDefault(group => group.Department == department && group.HISDeptName == hISDeptName
                        && UnitTypeUtil.IsEqualsUnitType(group.UnitType, unitType.ToString())
                        && (group.Source ?? "") == source);
                        //if (dic == null)
                        //    dic = dics.FirstOrDefault(group => group.Department == department && group.HISDeptName == hISDeptName && group.UnitType == unitType.ToString());
                        if (dic == null) return new Deptdic() { IsVerify = 1 };
                        return new Deptdic { Id = dic.Id, AccountingUnit = dic.AccountingUnit, IsVerify = dic.IsVerify ?? 1, VerifyMessage = dic.VerifyMessage, };
                    }

                    var result = depts
                        .GroupBy(t => new { t.HISDeptName, t.Department })
                        .Select(t => new DeptdicResponse
                        {
                            HospitalId = allot.HospitalId,
                            AllotId = allot.ID,
                            HISDeptName = t.Key.HISDeptName,
                            Department = t.Key.Department,
                            OutDoctorAccounting = GetDeptdic(t.ToList(), t.Key.Department, t.Key.HISDeptName, UnitType.医生组, "门诊"),
                            OutNurseAccounting = GetDeptdic(t.ToList(), t.Key.Department, t.Key.HISDeptName, UnitType.护理组, "门诊"),
                            OutTechnicAccounting = GetDeptdic(t.ToList(), t.Key.Department, t.Key.HISDeptName, UnitType.医技组, "门诊"),
                            InpatDoctorAccounting = GetDeptdic(t.ToList(), t.Key.Department, t.Key.HISDeptName, UnitType.医生组, "住院"),
                            InpatNurseAccounting = GetDeptdic(t.ToList(), t.Key.Department, t.Key.HISDeptName, UnitType.护理组, "住院"),
                            InpatTechnicAccounting = GetDeptdic(t.ToList(), t.Key.Department, t.Key.HISDeptName, UnitType.医技组, "住院"),
                            LogisticsAccounting = GetDeptdic(t.ToList(), t.Key.Department, t.Key.HISDeptName, UnitType.行政工勤),
                            SpecialAccounting = GetDeptdic(t.ToList(), t.Key.Department, t.Key.HISDeptName, UnitType.特殊核算组),
                            CreateTime = t.Max(group => group.CreateTime),
                            IsVerify = t.Min(w => w.IsVerify) ?? 1,
                        });

                    return result.OrderBy(w => w.IsVerify).ThenByDescending(t => t.CreateTime).ThenBy(t => t.Department);
                }
                catch (Exception)
                {
                    throw;
                }
            }
        }

        #endregion

        /// <summary>
        /// 科室改名历史数据处理
        /// </summary>
        /// <param name="allotId"></param>
        public Task RestoreSecondAllotAsync()
        {
            return Task.Factory.StartNew(() =>
            {
                using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
                {
                    if (connection.State != ConnectionState.Open) connection.Open();
                    try
                    {
                        string sql = $@"call proc_restore_secondallot()";
                        connection.Execute(sql, commandTimeout: 60 * 60);
                    }
                    catch (Exception)
                    {
                        throw;
                    }
                }
            });
        }

        public IEnumerable<dynamic> QuerySecondPrintHead(int allotId, string unitType, string accountingUnit)
        {
            using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
            {
                if (connection.State != ConnectionState.Open) connection.Open();

                string sql = $@"select * from view_second_print_header where AllotId = @allotId AND UnitType = @UnitType AND AccountingUnit = @AccountingUnit";
                return connection.Query(sql, new { allotId, unitType = unitType.Replace("行政后勤", "行政工勤"), accountingUnit }, commandTimeout: 60 * 60);
            }
        }

        public IEnumerable<dynamic> QuerySecondPrintRow(int allotId, string unitType, string accountingUnit)
        {
            using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
            {
                if (connection.State != ConnectionState.Open) connection.Open();
                string sql = $@"select * from view_second_print_row where AllotId = @allotId AND UnitType = @UnitType AND AccountingUnit = @AccountingUnit";
                return connection.Query(sql, new { allotId, unitType = unitType.Replace("行政后勤", "行政工勤"), accountingUnit }, commandTimeout: 60 * 60);
            }
        }
        public IEnumerable<dynamic> QueryTableStructure(string tableName)
        {
            using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
            {
                if (connection.State != ConnectionState.Open) connection.Open();

                string sql = $@"select column_name,ordinal_position from information_schema.`columns` where table_schema= database() and table_name = @tableName";
                return connection.Query(sql, new { tableName }, commandTimeout: 60 * 60);
            }
        }
        public IEnumerable<dynamic> QueryView(string viewName,int allotID)
        {
            using (var connection = new MySqlConnection(_options.Value.PerformanceConnectionString))
            {
                if (connection.State != ConnectionState.Open) connection.Open();

                string sql = $@"select * from {viewName} where allotID = @allotID";
                return connection.Query(sql,new { allotID }, commandTimeout: 60 * 60);
            }
        }
    }
}
