﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;

namespace Performance.DtoModels.Request
{
    public class SmsCodeRequest
    {
        /// <summary>
        /// 短信验证类型 1 手机号登录 2 其他
        /// </summary>
        public int Type { get; set; }
        public string Mobile { get; set; }
        public string Code { get; set; }
    }

    public class SmsCodeRequestValidator : AbstractValidator<SmsCodeRequest>
    {
        public SmsCodeRequestValidator()
        {
            RuleFor(x => x.Type).InclusiveBetween(1, 2);

            RuleFor(x => x.Mobile).Length(11).Must((pre) => { return CustomValidator.IsMobile(pre); });

            RuleSet("SmsCheck", () =>
            {
                RuleFor(x => x.Code).Length(4, 6);
            });
        }
    }
}
