﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;

namespace Performance.Infrastructure
{
    public static class CommonHelper
    {
        public static IEnumerable<T> ToDistinct<T>(this IEnumerable<T> source)
        {
            return source.Distinct(new TCompare<T>());
        }

        public static IEnumerable<T> ToDistinct<T, C>(this IEnumerable<T> source, Func<T, C> field)
        {
            return source.Distinct(new TCompare<T, C>(field));
        }

        public class TCompare<T> : IEqualityComparer<T>
        {
            public bool Equals(T x, T y)
            {
                try
                {
                    bool result = true;
                    PropertyInfo[] propertyInfos = typeof(T).GetProperties();
                    foreach (var propertyInfo in propertyInfos) //可设置i的起始值或判断i的值，来跳过不需要比较的字段      
                    {
                        result = propertyInfo.GetValue(x, null)?.ToString()
                            == propertyInfo.GetValue(y, null)?.ToString();
                        if (!result) break;
                    }
                    return result;
                }
                catch
                {
                    return false;
                }
            }
            public int GetHashCode(T obj)
            {
                return 1;
            }
        }

        public class TCompare<T, C> : IEqualityComparer<T>
        {
            private readonly Func<T, C> field;
            public TCompare(Func<T, C> field)
            {
                this.field = field;
            }
            public bool Equals(T x, T y)
            {
                return EqualityComparer<C>.Default.Equals(field(x), field(y));
            }
            public int GetHashCode(T obj)
            {
                return EqualityComparer<C>.Default.GetHashCode(field(obj));
            }
        }
    }
}
