﻿using AutoMapper;
using Performance.EntityModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.DtoModels.AutoMapper
{
    public class AutoMapperConfigs : Profile
    {
        public AutoMapperConfigs()
        {
            //用户登录信息
            CreateMap<UserIdentity, sys_user>()
                .ForMember(dest => dest.ID, opt => opt.MapFrom(src => src.UserID));
            CreateMap<sys_user, UserIdentity>()
                .ForMember(dest => dest.UserID, opt => opt.MapFrom(src => src.ID));

            //用户 响应
            CreateMap<UserResponse, sys_user>()
                .ForMember(dest => dest.ID, opt => opt.MapFrom(src => src.UserID));
            CreateMap<sys_user, UserResponse>()
                .ForMember(dest => dest.UserID, opt => opt.MapFrom(src => src.ID));

            //用户新增/修改 请求
            CreateMap<UserRequest, sys_user>();
            CreateMap<sys_user, UserRequest>();

            // 用户医院列表 响应
            CreateMap<HospitalResponse, sys_hospital>()
                .ForMember(dest => dest.ID, opt => opt.MapFrom(src => src.HosID));
            CreateMap<sys_hospital, HospitalResponse>()
                .ForMember(dest => dest.HosID, opt => opt.MapFrom(src => src.ID));

            // 医院新增/修改 请求
            CreateMap<HospitalRequest, sys_hospital>();
            CreateMap<sys_hospital, HospitalRequest>();

            // 角色 响应
            CreateMap<RoleResponse, sys_role>()
                .ForMember(dest => dest.ID, opt => opt.MapFrom(src => src.RoleID));
            CreateMap<sys_role, RoleResponse>()
                .ForMember(dest => dest.RoleID, opt => opt.MapFrom(src => src.ID));

            // 菜单 响应
            CreateMap<MenuResponse, sys_menu>()
                .ForMember(dest => dest.ID, opt => opt.MapFrom(src => src.MenuID));
            CreateMap<sys_menu, MenuResponse>()
                .ForMember(dest => dest.MenuID, opt => opt.MapFrom(src => src.ID));

            // 绩效 请求
            CreateMap<AllotRequest, per_allot>();
            CreateMap<per_allot, AllotRequest>();

            // 绩效 响应
            CreateMap<AllotResponse, per_allot>();
            CreateMap<per_allot, AllotResponse>();


            // sheet 响应
            CreateMap<SheetResponse, per_sheet>()
                 .ForMember(dest => dest.ID, opt => opt.MapFrom(src => src.SheetID));
            CreateMap<per_sheet, SheetResponse>()
                .ForMember(dest => dest.SheetID, opt => opt.MapFrom(src => src.ID));

            CreateMap<PerHeader, im_header>()
                .ForMember(dest => dest.IsMerge, opt => opt.MapFrom(src => src.IsMerge ? 1 : 2));

            CreateMap<PerData, im_data>()
                .ForMember(dest => dest.IsFactor, opt => opt.MapFrom(src => src.IsFactor ? 1 : 2))
                .ForMember(dest => dest.UnitType, opt => opt.MapFrom(src => EnumHelper.GetItems<UnitType>().FirstOrDefault(t => t.Name == src.UnitType).Value));

            CreateMap<im_header, PerHeader>()
                .ForMember(dest => dest.IsMerge, opt => opt.MapFrom(src => src.IsMerge == 1 ? true : false));
            CreateMap<im_data, PerData>()
                .ForMember(dest => dest.IsFactor, opt => opt.MapFrom(src => src.IsFactor == 1 ? true : false))
                .ForMember(dest => dest.UnitType, opt => opt.MapFrom(src => EnumHelper.GetItems<UnitType>().FirstOrDefault(t => t.Value == src.UnitType).Name));

            CreateMap<PerDataEmployee, im_employee>();
            CreateMap<im_employee, PerDataEmployee>();

            //CreateMap<PerDataAccountBaisc, PerDataAccount>()
            //    .ForMember(dest => dest.AccountingUnit, opt => opt.MapFrom(src => src.AccountingUnit))
            //    .ForMember(dest => dest.Department, opt => opt.MapFrom(src => src.Department))
            //    .ForMember(dest => dest.Number, opt => opt.MapFrom(src => src.Number))
            //    .ForMember(dest => dest.BasicFactor, opt => opt.MapFrom(src => src.BasicFactor))
            //    .ForMember(dest => dest.SlopeFactor, opt => opt.MapFrom(src => src.SlopeFactor))
            //    .ForMember(dest => dest.OtherPerfor1, opt => opt.MapFrom(src => src.OtherPerfor1))
            //    .ForMember(dest => dest.OtherPerfor2, opt => opt.MapFrom(src => src.OtherPerfor2))
            //    .ForMember(dest => dest.Extra, opt => opt.MapFrom(src => src.Extra))
            //    .ForMember(dest => dest.ScoringAverage, opt => opt.MapFrom(src => src.ScoringAverage))
            //    .ForMember(dest => dest.AdjustFactor, opt => opt.MapFrom(src => src.AdjustFactor));

            //CreateMap<PerDataAccountBaisc, PerDataAccount>()
            //    .ForMember(dest => dest.AccountingUnit, opt => opt.MapFrom(src => src.AccountingUnit))
            //    .ForMember(dest => dest.Department, opt => opt.MapFrom(src => src.Department))
            //    .ForMember(dest => dest.Number, opt => opt.MapFrom(src => src.Number))
            //    .ForMember(dest => dest.BasicFactor, opt => opt.MapFrom(src => src.BasicFactor))
            //    .ForMember(dest => dest.SlopeFactor, opt => opt.MapFrom(src => src.SlopeFactor))
            //    .ForMember(dest => dest.OtherPerfor1, opt => opt.MapFrom(src => src.OtherPerfor1))
            //    .ForMember(dest => dest.OtherPerfor2, opt => opt.MapFrom(src => src.OtherPerfor2))
            //    .ForMember(dest => dest.Extra, opt => opt.MapFrom(src => src.Extra))
            //    .ForMember(dest => dest.ScoringAverage, opt => opt.MapFrom(src => src.ScoringAverage))
            //    .ForMember(dest => dest.AdjustFactor, opt => opt.MapFrom(src => src.AdjustFactor));

            //CreateMap<PerDataAccountBaisc, im_accountbasic>();
            //CreateMap<im_accountbasic, PerDataAccountBaisc>();
            CreateMap<PerDataAccountBaisc, im_accountbasic>()
                 .ForMember(dest => dest.UnitType, opt => opt.MapFrom(src => EnumHelper.GetItems<UnitType>().First(t => t.Name == src.UnitType).Value))
                 .ForMember(dest => dest.DoctorAccountingUnit, opt => opt.MapFrom(src => src.AccountingUnit))
                 .ForMember(dest => dest.Department, opt => opt.MapFrom(src => src.Department))
                 .ForMember(dest => dest.DoctorDirectorNumber, opt => opt.MapFrom(src => src.ManagerNumber))
                 .ForMember(dest => dest.DoctorNumber, opt => opt.MapFrom(src => src.Number))
                 .ForMember(dest => dest.DoctorBasicFactor, opt => opt.MapFrom(src => src.BasicFactor))
                 .ForMember(dest => dest.DoctorSlopeFactor, opt => opt.MapFrom(src => src.SlopeFactor))
                 .ForMember(dest => dest.DoctorOtherPerfor1, opt => opt.MapFrom(src => src.OtherPerfor1))
                 .ForMember(dest => dest.DoctorOtherPerfor2, opt => opt.MapFrom(src => src.OtherPerfor2))
                 .ForMember(dest => dest.DoctorExtra, opt => opt.MapFrom(src => src.Extra))
                 .ForMember(dest => dest.DoctorScoringAverage, opt => opt.MapFrom(src => src.ScoringAverage))
                 .ForMember(dest => dest.DoctorAdjustFactor, opt => opt.MapFrom(src => src.AdjustFactor))
                 .ForMember(dest => dest.DoctorScale, opt => opt.MapFrom(src => src.Scale))
                 .ForMember(dest => dest.DoctorEffic, opt => opt.MapFrom(src => src.Effic))
                 .ForMember(dest => dest.DoctorGrant, opt => opt.MapFrom(src => src.Grant));


            CreateMap<im_accountbasic, PerDataAccountBaisc>()
                 .ForMember(dest => dest.UnitType, opt => opt.MapFrom(src => src.UnitType))
                 .ForMember(dest => dest.AccountingUnit, opt => opt.MapFrom(src => src.DoctorAccountingUnit))
                 .ForMember(dest => dest.Department, opt => opt.MapFrom(src => src.Department))
                 .ForMember(dest => dest.ManagerNumber, opt => opt.MapFrom(src => src.DoctorDirectorNumber))
                 .ForMember(dest => dest.Number, opt => opt.MapFrom(src => src.DoctorNumber))
                 .ForMember(dest => dest.BasicFactor, opt => opt.MapFrom(src => src.DoctorBasicFactor))
                 .ForMember(dest => dest.SlopeFactor, opt => opt.MapFrom(src => src.DoctorSlopeFactor))
                 .ForMember(dest => dest.OtherPerfor1, opt => opt.MapFrom(src => src.DoctorOtherPerfor1))
                 .ForMember(dest => dest.OtherPerfor2, opt => opt.MapFrom(src => src.DoctorOtherPerfor2))
                 .ForMember(dest => dest.Extra, opt => opt.MapFrom(src => src.DoctorExtra))
                 .ForMember(dest => dest.ScoringAverage, opt => opt.MapFrom(src => src.DoctorScoringAverage))
                 .ForMember(dest => dest.AdjustFactor, opt => opt.MapFrom(src => src.DoctorAdjustFactor))
                 .ForMember(dest => dest.Scale, opt => opt.MapFrom(src => src.DoctorScale))
                 .ForMember(dest => dest.Effic, opt => opt.MapFrom(src => src.DoctorEffic))
                 .ForMember(dest => dest.Grant, opt => opt.MapFrom(src => src.DoctorGrant));

            CreateMap<PerDataSpecialUnit, im_specialunit>();
            //CreateMap<PerDataAccountDoctor, res_accountdoctor>();
            //CreateMap<PerDataAccountNurse, res_accountnurse>();
            //CreateMap<res_accountdoctor, PerDataAccountBaisc>();
            CreateMap<res_account, PerDataAccountBaisc>()
                .ForMember(dest => dest.UnitType, opt => opt.MapFrom(src => ((UnitType)src.UnitType).ToString()));
            CreateMap<PerDataAccountBaisc, res_account>()
                .ForMember(dest => dest.UnitType, opt => opt.MapFrom(src => EnumHelper.GetItems<UnitType>().First(t => t.Name == src.UnitType).Value));
            //CreateMap<PerDataAccountBaisc, res_accountnurse>();

            //CreateMap<res_accountdoctor, ComputeSource>();
            //CreateMap<res_accountnurse, ComputeSource>();
            CreateMap<im_employee, ComputeEmployee>();
            CreateMap<ComputeResult, res_compute>();

            CreateMap<res_account, DeptResponse>();
            //CreateMap<res_account, NurseResponse>();


            //二次绩效
            CreateMap<ag_header, PerHeader>();
            CreateMap<PerHeader, ag_header>();

            CreateMap<PerAgainData, ag_data>();
            CreateMap<ag_data, PerAgainData>();

            CreateMap<PerAgainEmployee, ag_employee>();
            CreateMap<ag_employee, PerAgainEmployee>();

            CreateMap<PerAgainSituation, ag_againsituation>();
            CreateMap<ag_againsituation, PerAgainSituation>();

            CreateMap<per_againallot, AgainAllotResponse>();
            CreateMap<res_compute, ComputeResponse>();
            CreateMap<EmployeeRequest, im_employee>();
            CreateMap<res_compute, ResComputeResponse>();

            CreateMap<UseTempRequest, ag_usetemp>()
                .ForMember(dest => dest.UseTempId, opt => opt.MapFrom(src => src.TempId))
                .ReverseMap();

            CreateMap<ag_tempitem, HeadItem>();
            CreateMap<ag_workload, HeadItem>()
                .ForMember(dest => dest.FiledId, opt => opt.MapFrom(src => src.ItemId))
                .ForMember(dest => dest.FiledName, opt => opt.MapFrom(src => src.ItemName));
            CreateMap<ag_fixatitem, BodyItem>()
                .ForMember(dest => dest.FiledName, opt => opt.MapFrom(src => src.ItemName))
                .ForMember(dest => dest.Value, opt => opt.MapFrom(src => src.ItemValue));
            CreateMap<ag_temp, SecondTempResponse>();

            CreateMap<ag_secondallot, SecondListResponse>().ReverseMap();
        }
    }
}
