//-----------------------------------------------------------------------
// <copyright file=" sys_allot.cs">
// * FileName: sys_allot.cs
// * history : Created by T4 2019-03-06 16:43:31 
// </copyright>
//-----------------------------------------------------------------------
using Performance.EntityModels;
using System;

namespace Performance.Repository
{
    /// <summary>
    /// sys_allot Repository
    /// </summary>
    public partial class PerforPerallotRepository : PerforRepository<per_allot>
    {
        public bool UpdateAllotStates(int allotId, int states, string remark)
        {
            var allot = GetEntity(t => t.ID == allotId);
            allot.States = states;
            allot.Remark = remark;
            return Update(allot);
        }

        public int ImportData(int allotId)
        {
            string sql = @"
insert into report_allot_summary(allotid,year,month,hospitalid,realgivefee)
select allotid,year,month,hospitalid,realgivefee from view_report_allot_summary where allotid=@allotId;
insert into report_original_income(allotid,year,month,hospitalid,sourcetype,accountingunit,department,typename,cellvalue)
select allotid,year,month,hospitalid,sourcetype,accountingunit,department,typename,cellvalue from view_report_original_income where allotid=@allotId;";
            return Execute(sql, new { allotId });
        }
    }
}
