﻿using Microsoft.Extensions.Options;
using Performance.Subsidy.Services.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Performance.Subsidy.Services
{
    public class ConnectionStringBuilder
    {
        private readonly IOptions<ConnectionStringTemplates> _options;

        public ConnectionStringBuilder(IOptions<ConnectionStringTemplates> options)
        {
            _options = options;
        }

        public string GetConnectionString(int type, string ip, string database, string uid, string pwd)
        {
            switch (type)
            {
                case (int)DatabaseType.MySQL:
                    return string.Format(_options.Value.MySQLTemplates, ip, database, uid, pwd);

                case (int)DatabaseType.SqlServer:
                    return string.Format(_options.Value.SqlServerTemplates, ip, database, uid, pwd);

                case (int)DatabaseType.Oracle:
                    return string.Format(_options.Value.OracleTemplates, ip, database, uid, pwd);

                default:
                    throw new ArgumentException("DatabaseType类型不支持");
            }
        }
    }
}
