﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class ApiResponse<TEntity>
        where TEntity : class, new()
    {
        public ResponseType State { get; set; }
        /// <summary>
        /// 消息内容。
        /// </summary>
        public string Message { get; set; }
        /// <summary>
        /// 返回数据。
        /// </summary>
        public TEntity Data { get; set; }

        public ApiResponse()
            : this(ResponseType.Fail, "", null)
        {
        }
        public ApiResponse(ResponseType type)
            : this(type, type.ToString(), null)
        {
        }

        public ApiResponse(ResponseType type, string message)
            : this(type, message, null)
        {
        }

        public ApiResponse(ResponseType type, TEntity entity)
            : this(type, type.ToString(), entity)
        {
        }

        public ApiResponse(ResponseType type, string message, TEntity entity)
        {
            State = type;
            Message = message;
            Data = entity;
        }
    }

    public sealed class ApiResponse : ApiResponse<Object>
    {
        public ApiResponse()
        {
        }

        public ApiResponse(ResponseType type) : base(type)
        {
        }

        public ApiResponse(ResponseType type, string message) : base(type, message)
        {
        }

        public ApiResponse(ResponseType type, object entity) : base(type, entity)
        {
        }

        public ApiResponse(ResponseType type, string message, object entity) : base(type, message, entity)
        {
        }
    }
}
