﻿using FluentValidation.AspNetCore;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Caching.Memory;
using Microsoft.Extensions.Options;
using Newtonsoft.Json.Linq;
using Performance.DtoModels;
using Performance.DtoModels.AppSettings;
using Performance.EntityModels;
using Performance.Infrastructure;
using Performance.Services;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Performance.Api.Controllers
{
    [Route("api/[controller]")]
    public class AssessController : Controller
    {
        private ClaimService claimService;
        private AssessService assessService;
        private UserService userService;
        public AssessController(ClaimService claimService,
            AssessService assessService, UserService userService)
        {
            this.claimService = claimService;
            this.assessService = assessService;
            this.userService = userService;
        }

        //考核类别列表
        [HttpPost]
        [Route("assesslist")]
        public ApiResponse AssessList([CustomizeValidator(RuleSet = "List"), FromBody]AssessRequest request)
        {
            return assessService.AssessList(request.AllotID);
        }

        //新增考核类别
        [HttpPost]
        [Route("addassess")]
        public ApiResponse AddAssess([CustomizeValidator(RuleSet = "Add"), FromBody]AssessRequest request)
        {
            return assessService.AddAssess(request.AllotID, request.AssessName);
        }

        //修改考核类别
        [HttpPost]
        [Route("editassess")]
        public ApiResponse EditAssess([CustomizeValidator(RuleSet = "Update"), FromBody]AssessRequest request)
        {
            return assessService.EditAssess(request.AssessID, request.AssessName);
        }

        //删除考核类别
        [HttpPost]
        [Route("delassess")]
        public ApiResponse DelAssess([CustomizeValidator(RuleSet = "Del"), FromBody]AssessRequest request)
        {
            return assessService.DelAssess(request.AssessID);
        }

        //获取所有科室列表
        [HttpPost]
        [Route("departmentlist")]
        public ApiResponse DepartmentList([CustomizeValidator(RuleSet = "Use"), FromBody]AssessRequest request)
        {
            var department = assessService.Department(request);
            return new ApiResponse(ResponseType.OK, "ok", department);
        }

        //设置科室考核分类
        [HttpPost]
        [Route("setassesstype")]
        public ApiResponse SetAssessType([FromBody]SetAssessRequest request)
        {
            return assessService.SetAssessType(request);
        }

        //考核列头列表
        [HttpPost]
        [Route("columnlist")]
        public ApiResponse ColumnList([CustomizeValidator(RuleSet = "List"), FromBody]AssessColumnRequest request)
        {
            return assessService.ColumnList(request.AssessID);
        }

        //新增考核项
        [HttpPost]
        [Route("addcolumn")]
        public ApiResponse AddColumn([CustomizeValidator(RuleSet = "Add"), FromBody]AssessColumnRequest request)
        {
            return assessService.AddColumn(request.AssessID, request.ParentID, request.ColumnName, request.Sort);
        }

        //修改考核项
        [HttpPost]
        [Route("editcolumn")]
        public ApiResponse EditColumn([CustomizeValidator(RuleSet = "Update"), FromBody]AssessColumnRequest request)
        {
            return assessService.EditColumn(request.ColumnID, request.ColumnName, request.Sort);
        }

        //删除考核项
        [HttpPost]
        [Route("delcolumn")]
        public ApiResponse DelColumn([CustomizeValidator(RuleSet = "Del"), FromBody]AssessColumnRequest request)
        {
            return assessService.DelColumn(request.ColumnID);
        }

        //考核数据列表
        [HttpPost]
        [Route("datalist")]
        public ApiResponse DataList([CustomizeValidator(RuleSet = "List"), FromBody]AssessDataRequest request)
        {
            return assessService.DataList(request.AssessID);
        }

        //考核数据修改
        [HttpPost]
        [Route("editassessdata")]
        public ApiResponse EditAssessData([CustomizeValidator(RuleSet = "Edit"), FromBody]AssessDataRequest request)
        {
            return assessService.EditAssessData(request.AssessRow);
        }

        //考核模版列表
        [HttpPost]
        [Route("tempassesslist")]
        public ApiResponse TempAssessList()
        {
            return assessService.TempAssessList();
        }

        //模板列头列表
        [HttpPost]
        [Route("tempcolumnlist")]
        public ApiResponse TempColumnList([CustomizeValidator(RuleSet = "List"), FromBody]AssessColumnRequest request)
        {
            return assessService.TempColumnList(request.AssessID);
        }

        //使用考核模版
        [HttpPost]
        [Route("usetemplate")]
        public ApiResponse UseTemplate([CustomizeValidator(RuleSet = "Use"), FromBody]AssessRequest request)
        {
            return assessService.UseTemplate(request.AllotID, request.AssessID);
        }
    }
}
