﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class ExtractRequest
    {
        /// <summary>
        /// 绩效ID
        /// </summary> 
        public int AllotId { get; set; }

        /// <summary>
        /// 医院ID
        /// </summary> 
        public int HospitalId { get; set; }

        /// <summary>
        /// 使用方案
        /// </summary> 
        public int UseScheme { get; set; }

        /// <summary>
        /// 邮箱
        /// </summary>
        public string Email { get; set; }
    }


    public class ExtractRequestValidator : AbstractValidator<ExtractRequest>
    {
        public ExtractRequestValidator()
        {
            RuleFor(x => x.AllotId).NotNull().GreaterThan(0);
            RuleFor(x => x.HospitalId).NotNull().GreaterThan(0);
            //RuleFor(x => x.UseScheme).NotNull().InclusiveBetween(1, 2);
        }
    }
}
