﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class UseTempRequest
    {
        public int TempId { get; set; }

        public int HospitalId { get; set; }

        public string Department { get; set; }

        public string UnitType { get; set; }

        public int SecondId { get; set; }

        /// <summary> 是否归档 </summary>
        public int IsArchive { get; set; }
    }
    public class UseTempRequestValidator : AbstractValidator<UseTempRequest>
    {
        public UseTempRequestValidator()
        {
            RuleSet("Use", () =>
            {
                RuleFor(x => x.TempId).NotNull().GreaterThan(0);
                RuleFor(x => x.HospitalId).NotNull().GreaterThan(0);
                RuleFor(x => x.Department).NotNull().NotEmpty();
                RuleFor(x => x.UnitType).NotNull().NotEmpty();
            });

            RuleSet("Refresh", () =>
            {
                RuleFor(x => x.HospitalId).NotNull().GreaterThan(0);
                RuleFor(x => x.Department).NotNull().NotEmpty();
                RuleFor(x => x.UnitType).NotNull().NotEmpty();
                RuleFor(x => x.SecondId).NotNull().GreaterThan(0);
            });
        }
    }
}
