﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class WorkloadRequest
    {
        /// <summary>
        /// 绩效ID
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 医院ID
        /// </summary>
        public Nullable<int> HospitalId { get; set; }

        /// <summary>
        /// 科室
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string UnitType { get; set; }

        /// <summary>
        /// 工作量名称
        /// </summary>
        public string ItemName { get; set; }

        /// <summary>
        /// 工作量系数
        /// </summary>
        public Nullable<decimal> FactorValue { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<decimal> Sort { get; set; }
    }
    public class WorkloadRequestValidator : AbstractValidator<WorkloadRequest>
    {
        public WorkloadRequestValidator()
        {
            RuleSet("Add", () =>
            {
                RuleFor(x => x.HospitalId).NotNull().GreaterThan(0);
                RuleFor(x => x.Department).NotNull().NotEmpty();
                RuleFor(x => x.UnitType).NotNull().NotEmpty();
                RuleFor(x => x.ItemName).NotNull().NotEmpty();
            });

            RuleSet("Update", () =>
            {
                RuleFor(x => x.Id).NotNull().GreaterThan(0);
                RuleFor(x => x.HospitalId).NotNull().GreaterThan(0);
                RuleFor(x => x.ItemName).NotNull().NotEmpty();
            });

            RuleSet("Delete", () =>
            {
                RuleFor(x => x.Id).NotNull().GreaterThan(0);
            });
            RuleSet("Query", () =>
            {
                RuleFor(x => x.HospitalId).NotNull().GreaterThan(0);
                RuleFor(x => x.Department).NotNull().NotEmpty();
                RuleFor(x => x.UnitType).NotNull().NotEmpty();
            });
        }
    }
}
