﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    /// <summary>
    /// 临床科室单元核算表
    /// </summary>
    public class PerSheetDataReadDeptAccounting : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 1,
            HeaderLastRowNum = 1,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 2,
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();
            string[] headers = new string[]
            {
                "核算单元类型",
                "核算单元",
                "科室名称",
                "效率绩效人数",
                "科主任/护士长人数",
                "核算单元人员数量",
                "预算比例",
                "倾斜系数",
                "工作量倾斜系数",
                "保底绩效参考标准",
                "保底绩效系数",
                "其他绩效1",
                "其他绩效2",
                "医院奖罚",
                "考核得分率",
                "调节系数",
            };
            foreach (var item in headers)
            {
                if (!perHeader.Any(p => p.CellValue == item))
                    throw new NullReferenceException($"sheet '{sheet.SheetName}'中列'{item}'为空");
            }
            for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
            {
                var row = sheet.GetRow(r);
                if (row == null) continue;

                PerDataAccountBaisc unifyUnit = new PerDataAccountBaisc();
                unifyUnit.RowNumber = r;
                unifyUnit.UnitType = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元类型").PointCell)?.StringCellValue;
                unifyUnit.AccountingUnit = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元").PointCell)?.StringCellValue;
                unifyUnit.Department = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "科室名称").PointCell)?.StringCellValue;
                unifyUnit.PermanentStaff = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "效率绩效人数").PointCell)?.NumericCellValue);
                unifyUnit.ManagerNumber = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "科主任/护士长人数").PointCell)?.NumericCellValue);
                unifyUnit.Number = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元人员数量").PointCell)?.NumericCellValue);
                unifyUnit.BasicFactor = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "预算比例").PointCell)?.NumericCellValue);
                unifyUnit.SlopeFactor = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "倾斜系数").PointCell)?.NumericCellValue);
                //unifyUnit.Scale = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "规模绩效系数").PointCell)?.NumericCellValue);
                //unifyUnit.Effic = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "效率绩效系数").PointCell)?.NumericCellValue);
                //unifyUnit.Grant = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "管理绩效发放系数").PointCell)?.NumericCellValue);工作量倾斜系数
                unifyUnit.WorkSlopeFactor = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "工作量倾斜系数").PointCell)?.NumericCellValue);
                unifyUnit.MinimumReference = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "保底绩效参考标准").PointCell)?.StringCellValue;
                unifyUnit.MinimumFactor = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "保底绩效系数").PointCell)?.NumericCellValue);
                unifyUnit.OtherPerfor1 = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "其他绩效1").PointCell)?.NumericCellValue);
                unifyUnit.OtherPerfor2 = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "其他绩效2").PointCell)?.NumericCellValue);
                unifyUnit.Extra = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "医院奖罚").PointCell)?.NumericCellValue);
                unifyUnit.ScoringAverage = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "考核得分率").PointCell)?.NumericCellValue);
                unifyUnit.AdjustFactor = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "调节系数").PointCell)?.NumericCellValue);

                //unifyUnit.NurseHeadNumber = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元护士长数量" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                //unifyUnit.NurseNumber = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元护士数量" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                //unifyUnit.NurseBasicFactor = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "预算比例" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                //unifyUnit.NurseSlopeFactor = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "倾斜系数" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                //unifyUnit.NurseScale = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "规模绩效系数" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                //unifyUnit.NurseEffic = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "效率绩效系数" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                //unifyUnit.NurseGrant = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "管理绩效发放系数" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                //unifyUnit.NurseOtherPerfor1 = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "其他绩效1" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                //unifyUnit.NurseOtherPerfor2 = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "其他绩效2" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                //unifyUnit.NurseExtra = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "医院奖罚" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                //unifyUnit.NurseScoringAverage = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "考核得分率" && p.Parent.CellValue == "护理组").PointCell)?.ToString());
                //unifyUnit.NurseAdjustFactor = ConvertHelper.To<decimal>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "调节系数" && p.Parent.CellValue == "护理组").PointCell)?.ToString());

                if (!string.IsNullOrEmpty(unifyUnit.UnitType))
                    dataList.Add(unifyUnit);
            }

            return dataList;
        }

        /// <summary>
        /// 转换核算单元类型
        /// </summary>
        /// <param name="unitType"></param>
        /// <returns></returns>
        public int UnitType(string unitType)
        {
            switch (unitType)
            {
                case "医生组":
                    return 1;
                case "护理组":
                    return 2;
                case "医技组":
                    return 3;
                default:
                    return 0;
            }
        }
    }
}
