﻿using AutoMapper;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Infrastructure;
using Performance.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    /// <summary>
    /// 提供sheet数据查询服务
    /// </summary>
    public class SheetSevice : IAutoInjection
    {
        private PerforPerallotRepository _perforAllotRepository;
        private PerforPersheetRepository _perforImSheetRepository;
        private PerforImdataRepository _perforImDataRepository;
        private PerforImheaderRepository _perforImHeaderRepository;
        private PerforImemployeeRepository _perforImEmployeeRepository;
        private PerforImaccountbasicRepository _perforImaccountbasicRepository;
        private PerforResaccountRepository _perforResaccountRepository;
        //private PerforResaccountnurseRepository _perforImaccountnurseRepository;
        private PerforImspecialunitRepository _perforImspecialunitRepository;
        private PerforImemployeeclinicRepository _perforImemployeeclinicRepository;
        private readonly string[] percentparam = new string[] { "预算比例", "考核得分率", "调节系数" };

        public SheetSevice(PerforPerallotRepository perforAllotRepository,
            PerforPersheetRepository perforImSheetRepository,
            PerforImdataRepository perforImDataRepository,
            PerforImheaderRepository perforImHeaderRepository,
            PerforImemployeeRepository perforImEmployeeRepository,
            PerforImaccountbasicRepository perforImaccountbasicRepository,
            PerforResaccountRepository perforResaccountRepository,
            //PerforResaccountnurseRepository perforImaccountnurseRepository,
            PerforImspecialunitRepository perforImspecialunitRepository,
            PerforImemployeeclinicRepository perforImemployeeclinicRepository)
        {
            _perforAllotRepository = perforAllotRepository;
            _perforImSheetRepository = perforImSheetRepository;
            _perforImDataRepository = perforImDataRepository;
            _perforImHeaderRepository = perforImHeaderRepository;
            _perforImEmployeeRepository = perforImEmployeeRepository;
            _perforResaccountRepository = perforResaccountRepository;
            //_perforImaccountnurseRepository = perforImaccountnurseRepository;
            _perforImaccountbasicRepository = perforImaccountbasicRepository;
            _perforImspecialunitRepository = perforImspecialunitRepository;
            _perforImemployeeclinicRepository = perforImemployeeclinicRepository;
        }

        /// <summary>
        /// sheet 列表查询
        /// </summary>
        /// <param name="allotID"></param>
        /// <returns></returns>
        public List<SheetResponse> SheetList(int allotID, int source)
        {
            var allot = _perforAllotRepository.GetEntity(t => t.ID == allotID);
            if (allot == null)
                throw new PerformanceException("参数allotid无效");
            int[] arr = new int[] { 1, 2 };
            if (!arr.Contains(source))
                throw new PerformanceException("参数source无效");

            var sheetList = _perforImSheetRepository.GetEntities(t => t.AllotID == allotID && t.Source == source);
            return Mapper.Map<List<SheetResponse>>(sheetList);
        }

        /// <summary>
        /// sheet数据查询
        /// </summary>
        /// <param name="sheetID"></param>
        /// <returns></returns>
        public SheetExportResponse SheetExport(int sheetID)
        {
            var sheet = _perforImSheetRepository.GetEntity(t => t.ID == sheetID);
            if (sheet == null)
                throw new PerformanceException("参数sheetid无效");

            SheetExportResponse response = new SheetExportResponse(sheet.ID, sheet.SheetName, sheet.SheetType.Value);
            if (sheet.SheetType == (int)SheetType.Employee)
            {
                EmployeeExport(sheetID, response);
            }
            else if (sheet.SheetType == (int)SheetType.ClinicEmployee)
            {
                ClinicEmployeeExport(sheetID, response);
            }
            else if (sheet.SheetType == (int)SheetType.SpecialUnit)
            {
                SpecialUnitExport(sheetID, response);
            }
            //else if (sheet.SheetType == (int)SheetType.AccountBasic)
            //{
            //    AccountBaiscExport(sheetID, response);
            //}
            else if (sheet.SheetType == (int)SheetType.ComputeDoctorAccount)
            {
                AccountDoctorExport(sheetID, response);
            }
            else if (sheet.SheetType == (int)SheetType.ComputeNurseAccount)
            {
                AccountNurseExport(sheetID, response);
            }
            else
            {
                CommonExport(sheetID, response);
            }

            return response;
        }

        private void SpecialUnitExport(int sheetID, SheetExportResponse response)
        {
            var list = _perforImspecialunitRepository.GetEntities(t => t.SheetID == sheetID)?.OrderByDescending(t => t.AccountingUnit);

            if (list != null && list.Count() > 0)
            {
                var row = new Row(0);
                row.Data.Add(new Cell(1, "核算单元", 1, 1, false, false));
                row.Data.Add(new Cell(2, "科室", 1, 1, false, false));
                row.Data.Add(new Cell(3, "人数", 1, 1, false, true));
                row.Data.Add(new Cell(4, "量化指标", 1, 1, false, true));
                row.Data.Add(new Cell(5, "数量", 1, 1, false, true));
                row.Data.Add(new Cell(6, "量化指标绩效分值", 1, 1, false, true));
                row.Data.Add(new Cell(7, "考核得分率", 1, 1, false, true));
                row.Data.Add(new Cell(8, "其他绩效", 1, 1, false, true));
                row.Data.Add(new Cell(9, "医院奖罚", 1, 1, false, true));
                row.Data.Add(new Cell(10, "调节系数", 1, 1, false, true));
                response.Header.Add(row);
                for (int i = 0; i < list.Count(); i++)
                {
                    var item = list.ElementAt(i);
                    var rowbody = new Row(i);
                    rowbody.Data.Add(new Cell(1, item.AccountingUnit, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(2, item.Department, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(3, item.Number, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(4, item.QuantitativeIndicators, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(5, item.Quantity, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(6, item.QuantitativeIndicatorsValue, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(7, Math.Round(item.ScoringAverage.Value * 100, 2) + "%", 1, 1, false, true));
                    rowbody.Data.Add(new Cell(8, item.OtherPerfor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(9, item.Punishment, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(10, Math.Round(item.Adjust.Value * 100, 2) + "%", 1, 1, false, true));
                    response.Row.Add(rowbody);
                }
            }
        }

        private void CommonExport(int sheetID, SheetExportResponse response)
        {
            var headList = _perforImHeaderRepository.GetEntities(t => t.SheetID == sheetID)?.OrderBy(t => t.PointCell);
            if (headList == null) return;
            var dataList = _perforImDataRepository.GetEntities(t => t.SheetID == sheetID)?.OrderByDescending(t => t.AccountingUnit).ToList();

            var sheet = _perforImSheetRepository.GetEntity(t => t.ID == sheetID);

            //添加系数值
            #region 添加系数值
            int merge = 4;
            if (sheet.SheetType == (int)SheetType.Income && !headList.Select(t => t.CellValue).Contains("核算单元（医技组）"))
                merge = 3;

            var factorhead = new Row(0);
            if (sheet.SheetType == (int)SheetType.Workload)
            {
                factorhead.Data.Add(new Cell(0, "单元工作量绩效标准：", 1, 2, false, false));
                response = AddFactor(response, factorhead, headList.ToList(), dataList);
            }
            else if (sheet.SheetType == (int)SheetType.OtherIncome || sheet.SheetType == (int)SheetType.Income || sheet.SheetType == (int)SheetType.Expend)
            {
                factorhead.Data.Add(new Cell(0, "护理组分割比例", 1, merge, false, false));
                response = AddFactor(response, factorhead, headList.ToList(), dataList, UnitType.护理组);
                var factorhead1 = new Row(1);
                factorhead1.Data.Add(new Cell(0, "医生组分割比例", 1, merge, false, false));
                response = AddFactor(response, factorhead1, headList.ToList(), dataList, UnitType.医生组);
                var factorhead2 = new Row(2);
                factorhead2.Data.Add(new Cell(0, "医技组分割比例", 1, merge, false, false));
                response = AddFactor(response, factorhead2, headList.ToList(), dataList, UnitType.医技组);
            }

            if (sheet.SheetType == (int)SheetType.Income && !headList.Select(t => t.CellValue).Contains("核算单元（医技组）"))
            {
                //var technicianvalue = new Row(response.Header.Count()); technicianvalue.Data.Add(new Cell(0, "医技组核算收入", 1, 4, false, false));
                //response.Header.Add(technicianvalue);
                var technicianhead = new Row(response.Header.Count()); technicianhead.Data.Add(new Cell(0, "医技组核算单元", 1, merge, false, false));
                response.Header.Add(technicianhead);
                foreach (var header in headList)
                {
                    if (new List<string> { "核算单元（医技组）", "核算单元（医生组）", "核算单元（护理组）", "科室名称" }.Contains(header.CellValue)) continue;
                    var technician = dataList.FirstOrDefault(t => t.UnitType == 3 && t.TypeName == header.CellValue);
                    //technicianvalue.Data.Add(new Cell(header.PointCell.Value, technician.CellValue, header.MergeRow.Value, header.MergeCell.Value, header.IsTotal == 1, false));
                    technicianhead.Data.Add(new Cell(header.PointCell.Value, technician?.AccountingUnit ?? null, 1, 1, header.IsTotal == 1, false));
                }
            }

            #endregion

            //创建列头行
            #region 创建列头行
            var rowhead = new Row(response.Header.Count());
            response.Header.Add(rowhead);
            foreach (var header in headList.Where(t => !t.ParentID.HasValue || t.ParentID.Value == 0))
            {
                rowhead.Data.Add(new Cell(header.PointCell.Value, header.CellValue, header.MergeRow.Value, header.MergeCell.Value, header.IsTotal == 1, false));
            }
            if (headList.Any(t => t.ParentID.HasValue && t.ParentID.Value > 0))
            {
                var rowhead2 = new Row(response.Header.Count());
                response.Header.Add(rowhead2);
                foreach (var header in headList.Where(t => t.ParentID.HasValue && t.ParentID.Value > 0))
                {
                    rowhead2.Data.Add(new Cell(header.PointCell.Value, header.CellValue, header.MergeRow.Value, header.MergeCell.Value, header.IsTotal == 1, false));
                }
            }
            List<im_header> headers = new List<im_header>();
            foreach (var head in headList)
            {
                if (!headList.Any(t => t.ParentID == head.ID))
                    headers.Add(head);
            }
            #endregion

            //创建数据行
            #region 创建数据行
            if (dataList == null || dataList.Count == 0) return;
            Row rowbody = null;
            foreach (var rowNumber in dataList.Select(t => t.RowNumber).Distinct())     //.OrderBy(t => t)
            {
                foreach (var head in headers)
                {
                    if (rowbody == null || rowbody.Rownumber != rowNumber)
                    {
                        rowbody = new Row(rowNumber ?? 0);
                        response.Row.Add(rowbody);
                    }
                    if (head.CellValue.Contains("核算单元类型"))
                    {
                        var value = dataList.FirstOrDefault(t => t.RowNumber == rowNumber).UnitType;
                        rowbody.Data.Add(new Cell(head.PointCell.Value, ((UnitType)value).ToString(), 1, 1, false, false));
                    }
                    else if (head.CellValue.Contains("核算单元人员数量"))
                    {
                        var data = dataList.FirstOrDefault(t => t.RowNumber == rowNumber && t.SignID == head.SignID);
                        var value = data?.CellValue;
                        if (value.HasValue && value.Value > 0)
                            rowbody.Data.Add(new Cell(head.PointCell.Value, value, 1, 1, data.IsTotal == 1, true, data.Annotation));
                    }
                    else if (head.CellValue.Contains("核算单元"))
                    {
                        if (head.CellValue.Contains("医生组"))
                        {
                            var value = dataList.FirstOrDefault(t => t.RowNumber == rowNumber && t.UnitType == 1)?.AccountingUnit;
                            rowbody.Data.Add(new Cell(head.PointCell.Value, value, 1, 1, false, false));
                        }
                        else if (head.CellValue.Contains("护理组"))
                        {
                            var value = dataList.FirstOrDefault(t => t.RowNumber == rowNumber && t.UnitType == 2)?.AccountingUnit;
                            rowbody.Data.Add(new Cell(head.PointCell.Value, value, 1, 1, false, false));
                        }
                        else if (head.CellValue.Contains("医技组"))
                        {
                            var value = dataList.FirstOrDefault(t => t.RowNumber == rowNumber && t.UnitType == 3)?.AccountingUnit;
                            rowbody.Data.Add(new Cell(head.PointCell.Value, value, 1, 1, false, false));
                        }
                        else
                        {
                            var value = dataList.FirstOrDefault(t => t.RowNumber == rowNumber)?.AccountingUnit;
                            rowbody.Data.Add(new Cell(head.PointCell.Value, value, 1, 1, false, false));
                        }
                    }
                    else if (head.CellValue.Contains("科室名称"))
                    {
                        var value = dataList.FirstOrDefault(t => t.RowNumber == rowNumber).Department;
                        rowbody.Data.Add(new Cell(head.PointCell.Value, value, 1, 1, false, false));
                    }
                    else if (head.CellValue.Contains("备注"))
                    {
                        var value = dataList.FirstOrDefault(t => t.RowNumber == rowNumber).Remark;
                        rowbody.Data.Add(new Cell(head.PointCell.Value, value, 1, 1, false, false));
                    }
                    else if (!rowbody.Data.Any(t => t.PointCell == head.PointCell))
                    {
                        var data = dataList.FirstOrDefault(t => t.RowNumber == rowNumber && t.SignID == head.SignID);
                        var value = data?.CellValue;
                        if (value.HasValue)
                        {
                            if (!percentparam.Contains(head.CellValue))
                                rowbody.Data.Add(new Cell(head.PointCell.Value, value, 1, 1, data.IsTotal == 1, true, data.Annotation));
                            else
                                rowbody.Data.Add(new Cell(head.PointCell.Value, Math.Round(value.Value * 100, 2) + "%", 1, 1, data.IsTotal == 1, true, data.Annotation));
                        }
                    }
                }
            }
            #endregion
        }

        private void AccountNurseExport(int sheetID, SheetExportResponse response)
        {
            var list = _perforResaccountRepository.GetEntities(t => t.UnitType == (int)UnitType.护理组 && t.SheetID == sheetID)?.OrderByDescending(t => t.AccountingUnit);

            if (list != null && list.Count() > 0)
            {
                var row = new Row(0);
                row.Data.Add(new Cell(1, "核算单元", 1, 1, false, false));
                row.Data.Add(new Cell(2, "护士长人数", 1, 1, false, true));
                row.Data.Add(new Cell(3, "核算单元护士数量", 1, 1, false, true));
                row.Data.Add(new Cell(4, "医生基础系数", 1, 1, false, true));
                row.Data.Add(new Cell(5, "倾斜系数", 1, 1, false, true));
                row.Data.Add(new Cell(6, "其他绩效1", 1, 1, false, true));
                row.Data.Add(new Cell(7, "其他绩效2", 1, 1, false, true));
                row.Data.Add(new Cell(8, "医院奖罚", 1, 1, false, true));
                row.Data.Add(new Cell(9, "考核对分率", 1, 1, false, true));
                row.Data.Add(new Cell(10, "调节系数", 1, 1, false, true));
                row.Data.Add(new Cell(11, "科室业绩", 1, 1, false, true));
                row.Data.Add(new Cell(12, "业绩绩效", 1, 1, false, true));
                row.Data.Add(new Cell(13, "工作量绩效", 1, 1, false, true));
                row.Data.Add(new Cell(14, "绩效合计", 1, 1, false, true));
                row.Data.Add(new Cell(15, "人均绩效", 1, 1, false, true));
                row.Data.Add(new Cell(16, "实发绩效", 1, 1, false, true));

                response.Header.Add(row);
                for (int i = 0; i < list.Count(); i++)
                {
                    var item = list.ElementAt(i);
                    var rowbody = new Row(i);
                    rowbody.Data.Add(new Cell(1, item.AccountingUnit, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(2, item.ManagerNumber, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(3, item.Number, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(4, item.BasicFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(5, item.SlopeFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(6, item.OtherPerfor1, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(7, item.OtherPerfor2, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(8, item.Extra, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(9, item.ScoringAverage, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(10, item.AdjustFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(11, item.Income, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(12, item.PerforFee, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(13, item.WorkloadFee, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(14, item.PerforTotal, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(15, item.Avg, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(16, item.RealGiveFee, 1, 1, false, true));
                    response.Row.Add(rowbody);
                }
            }
        }

        private void AccountDoctorExport(int sheetID, SheetExportResponse response)
        {
            var list = _perforResaccountRepository.GetEntities(t => t.UnitType != (int)UnitType.护理组 && t.SheetID == sheetID)?.OrderByDescending(t => t.AccountingUnit);

            if (list != null && list.Count() > 0)
            {
                var row = new Row(0);
                row.Data.Add(new Cell(1, "核算单元", 1, 1, false, false));
                row.Data.Add(new Cell(2, "科主任人数", 1, 1, false, true));
                row.Data.Add(new Cell(3, "核算单元医生数量", 1, 1, false, true));
                row.Data.Add(new Cell(4, "医生基础系数", 1, 1, false, true));
                row.Data.Add(new Cell(5, "倾斜系数", 1, 1, false, true));
                row.Data.Add(new Cell(6, "其他绩效1", 1, 1, false, true));
                row.Data.Add(new Cell(7, "其他绩效2", 1, 1, false, true));
                row.Data.Add(new Cell(8, "医院奖罚", 1, 1, false, true));
                row.Data.Add(new Cell(9, "考核对分率", 1, 1, false, true));
                row.Data.Add(new Cell(10, "调节系数", 1, 1, false, true));
                row.Data.Add(new Cell(11, "科室业绩", 1, 1, false, true));
                row.Data.Add(new Cell(12, "业绩绩效", 1, 1, false, true));
                row.Data.Add(new Cell(13, "工作量绩效", 1, 1, false, true));
                row.Data.Add(new Cell(14, "绩效合计", 1, 1, false, true));
                row.Data.Add(new Cell(15, "人均绩效", 1, 1, false, true));
                row.Data.Add(new Cell(16, "实发绩效", 1, 1, false, true));

                response.Header.Add(row);
                for (int i = 0; i < list.Count(); i++)
                {
                    var item = list.ElementAt(i);
                    var rowbody = new Row(i);
                    rowbody.Data.Add(new Cell(1, item.AccountingUnit, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(2, item.ManagerNumber, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(3, item.Number, 1, 1, false, true));

                    rowbody.Data.Add(new Cell(4, item.BasicFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(5, item.SlopeFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(6, item.OtherPerfor1, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(7, item.OtherPerfor2, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(8, item.Extra, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(9, item.ScoringAverage, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(10, item.AdjustFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(11, item.Income, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(12, item.PerforFee, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(13, item.WorkloadFee, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(14, item.PerforTotal, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(15, item.Avg, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(16, item.RealGiveFee, 1, 1, false, true));

                    response.Row.Add(rowbody);
                }
            }
        }

        private void AccountBaiscExport(int sheetID, SheetExportResponse response)
        {
            var list = _perforImaccountbasicRepository.GetEntities(t => t.SheetID == sheetID)?.OrderBy(t => t.UnitType).ThenByDescending(t => t.DoctorAccountingUnit);

            if (list != null && list.Count() > 0)
            {
                var row = new Row(0);
                row.Data.Add(new Cell(1, "核算单元类型", 1, 1, false, false));
                row.Data.Add(new Cell(2, "核算单元", 1, 1, false, false));
                row.Data.Add(new Cell(3, "科室名称", 1, 1, false, false));
                row.Data.Add(new Cell(4, "科主任/护士长人数", 1, 1, false, false));
                row.Data.Add(new Cell(5, "核算单元人员数量", 1, 1, false, false));
                row.Data.Add(new Cell(6, "预算比例", 1, 1, false, false));
                row.Data.Add(new Cell(7, "倾斜系数", 1, 1, false, false));
                row.Data.Add(new Cell(8, "规模绩效系数", 1, 1, false, false));
                row.Data.Add(new Cell(9, "效率绩效系数", 1, 1, false, false));
                row.Data.Add(new Cell(10, "管理绩效发放系数", 1, 1, false, false));
                row.Data.Add(new Cell(11, "其他绩效1", 1, 1, false, false));
                row.Data.Add(new Cell(12, "考核得分率", 1, 1, false, false));
                row.Data.Add(new Cell(13, "医院奖罚", 1, 1, false, false));
                row.Data.Add(new Cell(14, "其他绩效2", 1, 1, false, false));
                row.Data.Add(new Cell(15, "调节系数", 1, 1, false, false));

                response.Header.Add(row);
                for (int i = 0; i < list.Count(); i++)
                {
                    var item = list.ElementAt(i);
                    var rowbody = new Row(i);
                    rowbody.Data.Add(new Cell(1, ((UnitType)item.UnitType).ToString(), 1, 1, false, false));
                    rowbody.Data.Add(new Cell(2, item.DoctorAccountingUnit, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(3, item.Department, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(4, item.DoctorDirectorNumber, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(5, item.DoctorNumber, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(6, item.DoctorBasicFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(7, item.DoctorSlopeFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(8, item.DoctorScale, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(9, item.DoctorEffic, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(10, item.DoctorGrant, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(11, item.DoctorOtherPerfor1, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(12, item.DoctorScoringAverage, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(13, item.DoctorExtra, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(14, item.DoctorOtherPerfor2, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(15, item.DoctorAdjustFactor, 1, 1, false, true));
                    response.Row.Add(rowbody);
                }
            }
        }

        private void EmployeeExport(int sheetID, SheetExportResponse response)
        {
            var employeeList = _perforImEmployeeRepository.GetEntities(t => t.SheetID == sheetID)?
                .OrderByDescending(t => t.AccountType)
                .ThenBy(t => t.AccountingUnit);

            if (employeeList != null && employeeList.Count() > 0)
            {
                var row = new Row(0);
                row.Data.Add(new Cell(1, "核算单元类型", 1, 1, false, false));
                row.Data.Add(new Cell(2, "核算单元", 1, 1, false, false));
                row.Data.Add(new Cell(3, "人员工号", 1, 1, false, false));
                row.Data.Add(new Cell(4, "医生姓名", 1, 1, false, true));
                row.Data.Add(new Cell(5, "职称", 1, 1, false, true));
                row.Data.Add(new Cell(6, "绩效基数核算参考对象", 1, 1, false, true));
                row.Data.Add(new Cell(7, "岗位系数", 1, 1, false, true));
                row.Data.Add(new Cell(8, "参加工作时间", 1, 1, false, true));
                row.Data.Add(new Cell(9, "考核得分率", 1, 1, false, true));
                row.Data.Add(new Cell(10, "出勤率", 1, 1, false, true));
                row.Data.Add(new Cell(11, "核算单元医生数", 1, 1, false, true));
                row.Data.Add(new Cell(12, "工作量绩效", 1, 1, false, true));
                row.Data.Add(new Cell(13, "其他绩效", 1, 1, false, true));
                row.Data.Add(new Cell(14, "医院奖罚", 1, 1, false, true));
                row.Data.Add(new Cell(15, "调节系数", 1, 1, false, true));
                row.Data.Add(new Cell(16, "发放系数", 1, 1, false, true));
                response.Header.Add(row);
                for (int i = 0; i < employeeList.Count(); i++)
                {
                    var item = employeeList.ElementAt(i);
                    var workTime = item.WorkTime != null ? ((DateTime)item.WorkTime).ToString("yyyy-MM-dd") : "";
                    var rowbody = new Row(i);
                    rowbody.Data.Add(new Cell(1, item.AccountType, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(2, item.AccountingUnit, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(3, item.PersonnelNumber, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(4, item.DoctorName, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(5, item.JobTitle, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(6, item.FitPeople, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(7, item.PostCoefficient, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(8, workTime, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(9, Math.Round(item.ScoreAverageRate.Value * 100, 2) + "%", 1, 1, false, true));
                    rowbody.Data.Add(new Cell(10, Math.Round(item.Attendance.Value * 100, 2) + "%", 1, 1, false, true));
                    rowbody.Data.Add(new Cell(11, item.PeopleNumber, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(12, item.Workload, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(13, item.OtherPerfor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(14, item.Punishment, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(15, Math.Round(item.Adjust.Value * 100, 2) + "%", 1, 1, false, true));
                    rowbody.Data.Add(new Cell(16, item.Grant, 1, 1, false, true));
                    response.Row.Add(rowbody);
                }
            }
        }

        private void ClinicEmployeeExport(int sheetID, SheetExportResponse response)
        {
            var clinicemployeeList = _perforImemployeeclinicRepository.GetEntities(t => t.SheetID == sheetID)?
                .OrderByDescending(t => t.UnitType)
                .ThenBy(t => t.AccountingUnit);

            if (clinicemployeeList != null && clinicemployeeList.Count() > 0)
            {
                var row = new Row(0);
                row.Data.Add(new Cell(1, "核算单元分类", 1, 1, false, false));
                row.Data.Add(new Cell(2, "核算单元", 1, 1, false, false));
                row.Data.Add(new Cell(3, "人员工号", 1, 1, false, false));
                row.Data.Add(new Cell(4, "医生姓名", 1, 1, false, true));
                row.Data.Add(new Cell(5, "职称", 1, 1, false, true));
                //row.Data.Add(new Cell(6, "绩效基数核算参考对象", 1, 1, false, true));
                row.Data.Add(new Cell(6, "岗位系数", 1, 1, false, true));
                row.Data.Add(new Cell(7, "效率绩效系数", 1, 1, false, true));
                row.Data.Add(new Cell(8, "规模绩效系数", 1, 1, false, true));
                row.Data.Add(new Cell(9, "管理绩效发放系数", 1, 1, false, true));
                //row.Data.Add(new Cell(8, "效率绩效系数", 1, 1, false, true));
                row.Data.Add(new Cell(10, "考核得分率", 1, 1, false, true));
                row.Data.Add(new Cell(11, "出勤率", 1, 1, false, true));
                //row.Data.Add(new Cell(11, "核算单元医生数", 1, 1, false, true));
                //row.Data.Add(new Cell(12, "工作量绩效", 1, 1, false, true));
                row.Data.Add(new Cell(12, "其他绩效", 1, 1, false, true));
                row.Data.Add(new Cell(13, "医院奖罚", 1, 1, false, true));
                row.Data.Add(new Cell(14, "调节系数", 1, 1, false, true));
                //row.Data.Add(new Cell(16, "发放系数", 1, 1, false, true));
                response.Header.Add(row);
                for (int i = 0; i < clinicemployeeList.Count(); i++)
                {
                    var item = clinicemployeeList.ElementAt(i);
                    //var workTime = item.WorkTime != null ? ((DateTime)item.WorkTime).ToString("yyyy-MM-dd") : "";
                    var rowbody = new Row(i);
                    rowbody.Data.Add(new Cell(1, item.UnitType, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(2, item.AccountingUnit, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(3, item.PersonnelNumber, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(4, item.DoctorName, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(5, item.JobTitle, 1, 1, false, true));
                    //rowbody.Data.Add(new Cell(6, item.FitPeople, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(6, item.PostCoefficient, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(7, Math.Round(item.Efficiency.Value * 100, 2) + "%", 1, 1, false, true));
                    rowbody.Data.Add(new Cell(8, Math.Round(item.Scale.Value * 100, 2) + "%", 1, 1, false, true));
                    rowbody.Data.Add(new Cell(9, Math.Round(item.Management.Value * 100, 2) + "%", 1, 1, false, true));
                    rowbody.Data.Add(new Cell(10, Math.Round(item.ScoreAverageRate.Value * 100, 2) + "%", 1, 1, false, true));
                    rowbody.Data.Add(new Cell(11, Math.Round(item.Attendance.Value * 100, 2) + "%", 1, 1, false, true));
                    rowbody.Data.Add(new Cell(12, item.OtherPerfor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(13, item.Punishment, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(14, Math.Round(item.Adjust.Value * 100, 2) + "%", 1, 1, false, true));
                    //rowbody.Data.Add(new Cell(16, item.Grant, 1, 1, false, true));
                    response.Row.Add(rowbody);
                }
            }
        }

        /// <summary>
        /// 添加系数值
        /// </summary>
        /// <param name="response"></param>
        /// <param name="row"></param>
        /// <param name="headList"></param>
        /// <param name="dataList"></param>
        /// <param name="type"></param>
        /// <returns></returns>
        private SheetExportResponse AddFactor(SheetExportResponse response, Row row, List<im_header> headList, List<im_data> dataList, UnitType? unitType = null)
        {
            response.Header.Add(row);
            if (unitType == null)
            {
                string[] array = new string[] { "核算单元", "科室名称" };
                foreach (var header in headList.Where(t => !t.ParentID.HasValue || t.ParentID.Value == 0))
                {
                    if (!array.Contains(header.CellValue))
                    {
                        var factor = dataList.Where(t => t.AllotID == header.AllotID && t.SheetID == header.SheetID && t.IsFactor == 1
                                 && t.TypeName == header.CellValue);
                        decimal? value = factor.Any() ? factor.FirstOrDefault().FactorValue : null;
                        row.Data.Add(new Cell(header.PointCell.Value, value, 1, 1, header.IsTotal == 1, false));
                    }
                }
            }
            else
            {
                string[] array = new string[] { "核算单元（医技组）", "核算单元（医生组）", "核算单元（护理组）", "科室名称" };
                foreach (var header in headList.Where(t => !t.ParentID.HasValue || t.ParentID.Value == 0))
                {
                    if (!array.Contains(header.CellValue))
                    {
                        var factor = dataList.Where(t => t.AllotID == header.AllotID && t.SheetID == header.SheetID && t.IsFactor == 1
                                     && t.TypeName == header.CellValue && t.UnitType == (int)unitType);
                        decimal? value = factor.Any() ? factor.FirstOrDefault().FactorValue : null;
                        row.Data.Add(new Cell(header.PointCell.Value, value, 1, 1, header.IsTotal == 1, false));
                    }
                }
            }
            return response;
        }
    }
}
