﻿using FluentValidation.AspNetCore;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Caching.Memory;
using Microsoft.Extensions.Options;
using Newtonsoft.Json.Linq;
using Performance.DtoModels;
using Performance.DtoModels.AppSettings;
using Performance.EntityModels;
using Performance.Infrastructure;
using Performance.Services;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Performance.Api.Controllers
{
    [Route("api/[controller]")]
    public class ConfigController : Controller
    {
        private ConfigService _configService;
        private AllotService _allotService;
        public ConfigController(ConfigService configService, AllotService allotService)
        {
            _configService = configService;
            _allotService = allotService;
        }

        #region director
        /// <summary>
        /// 获取规模/效率绩效配置列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("directorlist")]
        [HttpPost]
        public ApiResponse<List<DirectorResponse>> GetDireList([CustomizeValidator(RuleSet = "Select"), FromBody]DirectorRequest request)
        {
            var list = _configService.GetDireList(request.AllotID);
            return new ApiResponse<List<DirectorResponse>>(ResponseType.OK, "ok", list);
        }

        /// <summary>
        /// 新增规模/效率绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("direinsert")]
        [HttpPost]
        public ApiResponse<DirectorResponse> DireInsert([CustomizeValidator(RuleSet = "Insert"), FromBody]DirectorRequest request)
        {
            var director = _configService.DireInsert(request);
            return new ApiResponse<DirectorResponse>(ResponseType.OK, director);
        }

        /// <summary>
        /// 更新规模/效率绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("direupdate")]
        [HttpPost]
        public ApiResponse<DirectorResponse> DireUpdate([CustomizeValidator(RuleSet = "Update"), FromBody]DirectorRequest request)
        {
            var director = _configService.DireUpdate(request);
            return new ApiResponse<DirectorResponse>(ResponseType.OK, director);
        }

        /// <summary>
        /// 删除规模/效率绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("diredelete")]
        [HttpPost]
        public ApiResponse DireDelete([CustomizeValidator(RuleSet = "Delete"), FromBody]DirectorRequest request)
        {
            if (!_configService.DireDelete(request))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }
        #endregion

        #region drugprop
        /// <summary>
        /// 获取 药占比配置信息列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("drugproplist")]
        [HttpPost]
        public ApiResponse<List<DrugpropResponse>> GetDrugList([CustomizeValidator(RuleSet = "Select"), FromBody]DrugpropRequest request)
        {
            var list = _configService.GetDrugList(request.AllotID);
            return new ApiResponse<List<DrugpropResponse>>(ResponseType.OK, "ok", list);
        }

        /// <summary>
        /// 新增药占比配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("druginsert")]
        [HttpPost]
        public ApiResponse<DrugpropResponse> DrugInsert([CustomizeValidator(RuleSet = "Insert"), FromBody]DrugpropRequest request)
        {
            var drugprop = _configService.DrugInsert(request);
            return new ApiResponse<DrugpropResponse>(ResponseType.OK, drugprop);
        }

        /// <summary>
        /// 修改药占比配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("drugupdate")]
        [HttpPost]
        public ApiResponse<DrugpropResponse> Update([CustomizeValidator(RuleSet = "Update"), FromBody]DrugpropRequest request)
        {
            var drugprop = _configService.DrugUpdate(request);
            return new ApiResponse<DrugpropResponse>(ResponseType.OK, drugprop);
        }

        /// <summary>
        /// 删除药占比配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("drugdelete")]
        [HttpPost]
        public ApiResponse Delete([CustomizeValidator(RuleSet = "Delete"), FromBody]DrugpropRequest request)
        {
            if (!_configService.DrugDelete(request))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }
        #endregion

        #region drugprop
        /// <summary>
        /// 获取 药占比类型信息列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("dtypelist")]
        [HttpPost]
        public ApiResponse GetDrugtypeList([CustomizeValidator(RuleSet = "Select"), FromBody]DrugpropRequest request)
        {
            var list = _configService.GetDrugtypeList(request.AllotID);
            return new ApiResponse(ResponseType.OK, "ok", list);
        }

        /// <summary>
        /// 新增药占比类型
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("dtypeinsert")]
        [HttpPost]
        public ApiResponse DrugtypeInsert([CustomizeValidator(RuleSet = "Insert"), FromBody]DrugpropRequest request)
        {
            var drugprop = _configService.DrugtypeInsert(request);
            return new ApiResponse(ResponseType.OK, drugprop);
        }

        /// <summary>
        /// 修改药占比类型
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("dtypeupdate")]
        [HttpPost]
        public ApiResponse DrugtypeUpdate([CustomizeValidator(RuleSet = "Update"), FromBody]DrugpropRequest request)
        {
            var drugprop = _configService.DrugtypeUpdate(request);
            return new ApiResponse(ResponseType.OK, drugprop);
        }

        /// <summary>
        /// 删除药占比类型
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("dtypedelete")]
        [HttpPost]
        public ApiResponse DrugtypeDelete([CustomizeValidator(RuleSet = "Delete"), FromBody]DrugpropRequest request)
        {
            if (!_configService.DrugtypeDelete(request))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }
        #endregion

        #region income
        /// <summary>
        /// 获取ICU有效收入配置列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("incomelist")]
        [HttpPost]
        public ApiResponse<List<IncomeResponse>> GetIncomeList([CustomizeValidator(RuleSet = "Select"), FromBody]IncomeRequest request)
        {
            var list = _configService.GetIncomeList(request.AllotID);
            return new ApiResponse<List<IncomeResponse>>(ResponseType.OK, "ok", list);
        }

        /// <summary>
        /// 新增ICU有效收入配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("incomeinsert")]
        [HttpPost]
        public ApiResponse<IncomeResponse> Insert([CustomizeValidator(RuleSet = "Insert"), FromBody]IncomeRequest request)
        {
            var income = _configService.IncomeInsert(request);
            return new ApiResponse<IncomeResponse>(ResponseType.OK, income);
        }

        /// <summary>
        /// 修改ICU有效收入配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("incomeupdate")]
        [HttpPost]
        public ApiResponse<IncomeResponse> Update([CustomizeValidator(RuleSet = "Update"), FromBody]IncomeRequest request)
        {
            var income = _configService.IncomeUpdate(request);
            return new ApiResponse<IncomeResponse>(ResponseType.OK, income);
        }

        /// <summary>
        /// 删除ICU有效收入配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("incomedelete")]
        [HttpPost]
        public ApiResponse Delete([CustomizeValidator(RuleSet = "Delete"), FromBody]IncomeRequest request)
        {
            if (!_configService.IncomeDelete(request))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }
        #endregion

        #region workyear
        /// <summary>
        /// 获取年资系数配置列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("workyearlist")]
        [HttpPost]
        public ApiResponse<List<WorkyearResponse>> GetWorkList([CustomizeValidator(RuleSet = "Select"), FromBody]WorkyearRequest request)
        {
            var list = _configService.GetWorkList(request.AllotID);
            return new ApiResponse<List<WorkyearResponse>>(ResponseType.OK, "ok", list);
        }

        /// <summary>
        /// 新增年资系数配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("workinsert")]
        [HttpPost]
        public ApiResponse<WorkyearResponse> WorkyearInsert([CustomizeValidator(RuleSet = "Insert"), FromBody]WorkyearRequest request)
        {
            var workyear = _configService.WorkInsert(request);
            return new ApiResponse<WorkyearResponse>(ResponseType.OK, workyear);
        }

        /// <summary>
        /// 修改年资系数配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("workupdate")]
        [HttpPost]
        public ApiResponse<WorkyearResponse> WorkyearUpdate([CustomizeValidator(RuleSet = "Update"), FromBody]WorkyearRequest request)
        {
            var workyear = _configService.WorkUpdate(request);
            return new ApiResponse<WorkyearResponse>(ResponseType.OK, workyear);
        }

        /// <summary>
        /// 删除年资系数配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("workdelete")]
        [HttpPost]
        public ApiResponse WorkyearDelete([CustomizeValidator(RuleSet = "Delete"), FromBody]WorkyearRequest request)
        {
            if (!_configService.WorkDelete(request))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }
        #endregion

        #region cofagain
        /// <summary>
        /// 获取二次绩效配置列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("cofagainlist")]
        [HttpPost]
        public ApiResponse GetAgainList([CustomizeValidator(RuleSet = "Select"), FromBody]CofAgainRequest request)
        {
            var list = _configService.GetAgainList(request.AllotID);
            return new ApiResponse(ResponseType.OK, "ok", list);
        }

        /// <summary>
        /// 新增二次绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("cofagaininsert")]
        [HttpPost]
        public ApiResponse AgainInsert([CustomizeValidator(RuleSet = "Insert"), FromBody]CofAgainRequest request)
        {
            var workyear = _configService.AgainInsert(request);
            return new ApiResponse(ResponseType.OK, workyear);
        }

        /// <summary>
        /// 修改二次绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("cofagainupdate")]
        [HttpPost]
        public ApiResponse AgainUpdate([CustomizeValidator(RuleSet = "Update"), FromBody]CofAgainRequest request)
        {
            var workyear = _configService.AgainUpdate(request);
            return new ApiResponse(ResponseType.OK, workyear);
        }

        /// <summary>
        /// 删除二次绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("cofagaindelete")]
        [HttpPost]
        public ApiResponse AgainDelete([CustomizeValidator(RuleSet = "Delete"), FromBody]CofAgainRequest request)
        {
            if (!_configService.AgainDelete(request))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }
        #endregion

        #region workitem
        /// <summary>
        /// 获取工作量绩效配置列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("workitemlist")]
        [HttpPost]
        public ApiResponse<List<cof_workitem>> GetWorkItems([CustomizeValidator(RuleSet = "Select"), FromBody]WorkItemRequest request)
        {
            var list = _configService.GetWorkItems(request.AllotID);
            return new ApiResponse<List<cof_workitem>>(ResponseType.OK, "ok", list);
        }

        /// <summary>
        /// 新增工作量绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("workiteminsert")]
        [HttpPost]
        public ApiResponse<cof_workitem> WorkItemInsert([CustomizeValidator(RuleSet = "Insert"), FromBody]WorkItemRequest request)
        {
            var workyear = _configService.WorkItemInsert(request);
            return new ApiResponse<cof_workitem>(ResponseType.OK, workyear);
        }

        /// <summary>
        /// 修改工作量绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("workitemupdate")]
        [HttpPost]
        public ApiResponse<cof_workitem> WorkItemUpdate([CustomizeValidator(RuleSet = "Update"), FromBody]WorkItemRequest request)
        {
            var workyear = _configService.WorkItemUpdate(request);
            return new ApiResponse<cof_workitem>(ResponseType.OK, workyear);
        }

        /// <summary>
        /// 删除工作量绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("workitemdelete")]
        [HttpPost]
        public ApiResponse WorkItemDelete([CustomizeValidator(RuleSet = "Delete"), FromBody]WorkItemRequest request)
        {
            if (!_configService.WorkItemkDelete(request))
                return new ApiResponse(ResponseType.Fail);
            return new ApiResponse(ResponseType.OK);
        }
        #endregion

        /// <summary>
        /// 获取工作量绩效列头
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("workheader")]
        [HttpPost]
        public ApiResponse WorkHeader([CustomizeValidator(RuleSet = "Select"), FromBody]WorkItemRequest request)
        {
            var list = _configService.WorkHeader(request.AllotID);
            return new ApiResponse(ResponseType.OK, "ok", list);
        }
    }
}