﻿using FluentValidation.AspNetCore;
using Microsoft.AspNetCore.Mvc;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Services;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Performance.Api.Controllers
{
    [Route("api/[controller]")]
    public class GuaranteeController
    {
        private readonly GuaranteeService guaranteeService;
        public GuaranteeController(GuaranteeService guaranteeService)
        {
            this.guaranteeService = guaranteeService;
        }

        #region cof_guarantee
        /// <summary>
        /// 保底绩效配置列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("list")]
        [HttpPost]
        public ApiResponse<List<GuaranteeResponse>> Guarantee([CustomizeValidator(RuleSet = "Select"), FromBody]GuaranteeRequest request)
        {
            var list = guaranteeService.GuaranTree(request.AllotId);
            return new ApiResponse<List<GuaranteeResponse>>(ResponseType.OK, "ok", list);
        }

        /// <summary>
        /// 新增保底绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("insert")]
        [HttpPost]
        public ApiResponse<cof_guarantee> GuarantInsert([CustomizeValidator(RuleSet = "Insert"), FromBody]GuaranteeRequest request)
        {
            var entity = guaranteeService.GuarantInsert(request);
            if (entity.Id > 0)
                return new ApiResponse<cof_guarantee>(ResponseType.OK, "新增配置成功", entity);
            return new ApiResponse<cof_guarantee>(ResponseType.Fail, "新增配置失败", entity);
        }

        /// <summary>
        /// 修改保底绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("update")]
        [HttpPost]
        public ApiResponse<cof_guarantee> GuarantUpdate([CustomizeValidator(RuleSet = "Update"), FromBody]GuaranteeRequest request)
        {
            var result = guaranteeService.GuarantUpdate(request);
            return new ApiResponse<cof_guarantee>(ResponseType.OK, "修改配置成功", result);
        }

        /// <summary>
        /// 删除保底绩效配置
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("delete")]
        [HttpPost]
        public ApiResponse<cof_guarantee> GuarantDelete([CustomizeValidator(RuleSet = "Delete"), FromBody]GuaranteeRequest request)
        {
            var result = guaranteeService.GuarantDelete(request.Id);
            if (result)
                return new ApiResponse<cof_guarantee>(ResponseType.OK, "删除配置成功");
            return new ApiResponse<cof_guarantee>(ResponseType.Fail, "删除配置失败");
        }

        /// <summary>
        /// 医院核算单元
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [Route("accountingunit")]
        [HttpPost]
        public ApiResponse<List<TitleValue>> Accounting([CustomizeValidator(RuleSet = "Select"), FromBody]GuaranteeRequest request)
        {
            var result = guaranteeService.Accounting(request.AllotId);
            return new ApiResponse<List<TitleValue>>(ResponseType.OK, "医院核算单元列表", result);
        }
        #endregion
    }
}
