﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class PerDataSpecialUnit : IPerData
    {
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 科室名称
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// 人数
        /// </summary>
        public Nullable<decimal> Number { get; set; }

        /// <summary>
        /// 量化指标
        /// </summary>
        public string QuantitativeIndicators { get; set; }

        /// <summary>
        /// 数量
        /// </summary>
        public Nullable<decimal> Quantity { get; set; }

        /// <summary>
        /// 量化指标绩效分值
        /// </summary>
        public Nullable<decimal> QuantitativeIndicatorsValue { get; set; }

        /// <summary>
        /// 考核得分率
        /// </summary>
        public Nullable<decimal> ScoringAverage { get; set; }

        /// <summary>
        /// 其他绩效
        /// </summary>
        public Nullable<decimal> OtherPerfor { get; set; }

        /// <summary>
        /// 医院奖罚
        /// </summary>
        public Nullable<decimal> Punishment { get; set; }

        /// <summary>
        /// 调节系数
        /// </summary>
        public Nullable<decimal> Adjust { get; set; }
        public int RowNumber { get; set; }
    }
}
