﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class DeptDetailResponse
    {
        public PerDataAccountBaisc Pandect { get; set; }
        public List<DeptDetail> Economic { get; set; }
        public List<DeptDetail> Workload { get; set; }
    }

    public class DeptDetail
    {
        public string ItemName { get; set; }
        public decimal ItemValue { get; set; }
    }


    public class DeptDataDetails
    {
        /// <summary> 概览</summary>
        public PerDataAccountBaisc Pandect { get; set; }

        /// <summary> 收入明细 </summary>
        public List<DetailDtos> Detail { get; set; }
    }

    public class DetailDtos
    {
        /// <summary> 收入项名称 </summary>
        public string ItemName { get; set; }

        /// <summary> 1、收入 2、支出 3、工作量 </summary>
        public int IncomeType { get; set; }

        /// <summary> 金额 </summary>
        public decimal Amount { get; set; }

        /// <summary> 详情 </summary>
        public List<DetailModule> Items { get; set; }
    }

    public class DetailModule
    {
        /// <summary> 明细项 </summary>
        public string ItemName { get; set; }

        /// <summary> 原始值 </summary>
        public decimal? CellValue { get; set; }

        /// <summary> 系数 </summary>
        public decimal? Factor { get; set; }

        /// <summary> 结算值 </summary>
        public decimal? ItemValue { get; set; }
    }
}
