﻿using NPOI.HSSF.UserModel;
using NPOI.SS.UserModel;
using NPOI.XSSF.UserModel;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    public class AgainService : IAutoInjection
    {
        private PerHeaderService perHeaderService;
        private int DataFirstRowNum = 4;//数据起始行
        private int FactorRow = 3;//系数行
        public AgainService(PerHeaderService perHeaderService)
        {
            this.perHeaderService = perHeaderService;
        }

        /// <summary>
        /// 导入excel数据
        /// </summary>
        /// <param name="path"></param>
        /// <returns></returns>
        public PerAgainExcel ReadData(per_againallot again)
        {
            using (FileStream fs = new FileStream(again.Path, FileMode.Open))
            {
                var excelVersion = FileHelper.GetExtension(again.Path) == ".xlsx" ? ExcelVersion.xlsx : ExcelVersion.xls;
                IWorkbook workbook = (excelVersion == ExcelVersion.xlsx) ? (IWorkbook)(new XSSFWorkbook(fs)) : (IWorkbook)(new HSSFWorkbook(fs));
                for (int i = 0; i < workbook.NumberOfSheets; i++)
                {
                    var sheet = workbook.GetSheetAt(i);
                    if (sheet.SheetName == "二次分配表")
                    {
                        var point = new PerSheetPoint { DataFirstRowNum = 2, HeaderFirstCellNum = 0, HeaderFirstRowNum = 1, HeaderLastRowNum = 2 };
                        var perHeader = perHeaderService.GetPerHeader(sheet, point);
                        var results = ReadData(sheet, perHeader);

                        return new PerAgainExcel { Header = results.Header, AgainData = results.AgainData, AgainEmployee = results.AgainEmployee };
                    }
                }
            }
            return null;
        }

        private (PerHeader Header, List<PerAgainData> AgainData, List<PerAgainEmployee> AgainEmployee) ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<PerAgainData> slideDataList = new List<PerAgainData>();
            List<PerAgainEmployee> fixatDataList = new List<PerAgainEmployee>();
            var header = perHeader.FirstOrDefault(p => p.CellValue == "工作量绩效工资");
            if (header != null && header.Children != null)
            {
                for (int r = DataFirstRowNum; r < sheet.LastRowNum + 1; r++)
                {
                    var row = sheet.GetRow(r);
                    if (row == null) continue;

                    fixatDataList.Add(FixatRowRead(perHeader, r, row));
                    slideDataList.AddRange(SlideRowRead(sheet, header, r, row));
                }
            }
            return (header, slideDataList, fixatDataList);
        }
        /// <summary>
        /// 可扩展列读取
        /// </summary>
        /// <param name="sheet"></param>
        /// <param name="header"></param>
        /// <param name="r"></param>
        /// <param name="row"></param>
        /// <returns></returns>
        private List<PerAgainData> SlideRowRead(ISheet sheet, PerHeader header, int r, IRow row)
        {
            List<PerAgainData> slideDataList = new List<PerAgainData>();

            for (int c = 0; c < header.Children.Count(); c++)
            {
                var athead = header.Children.ElementAt(c);
                var cellValue = NopiSevice.GetCellValue(row.GetCell(athead.PointCell));
                if (!cellValue.HasValue || cellValue.Value == 0)
                    continue;
                var factorValue = ConvertHelper.To<decimal?>(sheet.GetRow(FactorRow).GetCell(athead.PointCell)?.ToString());
                PerAgainData data = new PerAgainData
                {
                    RowNumber = r,
                    TypeName = athead?.CellValue,
                    CellValue = cellValue,
                    IsTotal = 2,
                    IsFactor = factorValue.HasValue ? 1 : 2,
                    FactorValue = factorValue,
                    Annotation = row.GetCell(athead.PointCell)?.CellComment?.String?.String,
                    SignID = athead.SignID,
                };
                slideDataList.Add(data);
            }
            return slideDataList;
        }

        /// <summary>
        /// 固定列读取
        /// </summary>
        /// <param name="perHeader"></param>
        /// <param name="r"></param>
        /// <param name="row"></param>
        /// <returns></returns>
        private static PerAgainEmployee FixatRowRead(List<PerHeader> perHeader, int r, IRow row)
        {
            return new PerAgainEmployee
            {
                RowNumber = r,
                Name = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "姓名").PointCell)?.ToString(),
                JobTitle = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "职务").PointCell)?.ToString(),
                JobFactor = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "职称系数").PointCell)?.ToString()),
                Attendance = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "出勤").PointCell)?.ToString()),
                YearFactor = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "年资").PointCell)?.ToString()),
                Award = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "重点奖励").PointCell)?.ToString()),
                Allowance = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "管理津贴").PointCell)?.ToString()),
                AlonePerfor = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "单独核算人员绩效").PointCell)?.ToString()),
                NightShift = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "夜班费").PointCell)?.ToString()),
            };
        }
    }
}
