﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    /// <summary>
    /// 工作量
    /// </summary>
    public class PerSheetDataReadWorkload : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 1,
            HeaderLastRowNum = 1,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 3,
            AccountingUnit = new List<AccountingUnit>
            {
               new AccountingUnit
               {
                    AccountingUnitCellNum = 0,
                    DeptCellNum = 1,
                    FactorRow = 2
               }
            }
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            var unit = Point.AccountingUnit.First();
            //查询除了 核算单元  科室名称 有效数据列头位置
            var vhead = perHeader.Where(t => t.PointCell != unit.AccountingUnitCellNum && t.PointCell != unit.DeptCellNum).OrderBy(t => t.PointCell);

            for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
            {
                var row = sheet.GetRow(r);
                if (row == null) continue;

                for (int c = 0; c < vhead.Count(); c++)
                {
                    var athead = vhead.ElementAt(c);
                    var cellValue = NopiSevice.GetCellValue(row.GetCell(athead.PointCell));
                    if (!cellValue.HasValue || cellValue.Value == 0)
                        continue;

                    PerData data = new PerData
                    {
                        RowNumber = r,
                        SignID = athead.SignID,
                        AccountingUnit = row.GetCell(unit.AccountingUnitCellNum.Value)?.StringCellValue,
                        Department = row.GetCell(unit.DeptCellNum.Value)?.StringCellValue,
                        TypeName = athead?.CellValue,
                        CellValue = cellValue,
                        Annotation = row.GetCell(athead.PointCell)?.CellComment?.String?.String,
                        UnitType = unit.UnitType,
                        FactorValue = ConvertHelper.To<decimal?>(sheet.GetRow(unit.FactorRow.Value).GetCell(athead.PointCell)?.NumericCellValue),
                        IsFactor = true,
                    };
                    if (sheet.SheetName.Contains("医生组"))
                        data.UnitType = "医生组";
                    else if (sheet.SheetName.Contains("护理组"))
                        data.UnitType = "护理组";

                    dataList.Add(data);
                }
            }

            return dataList;
        }
    }
}
