﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class ComputeResponse
    {
        public ComputeResponse() { }

        public ComputeResponse(string source, string accountingUnit, string employeeName, string jobNumber, string jobTitle)
        {
            Source = source;
            AccountingUnit = accountingUnit;
            EmployeeName = employeeName;
            JobNumber = jobNumber;
            JobTitle = jobTitle;
        }

        /// <summary>
        /// 来源
        /// </summary>
        public string Source { get; set; }

        public string UnitType { get; set; }

        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 人员名称
        /// </summary>
        public string EmployeeName { get; set; }

        /// <summary>
        /// 工号
        /// </summary>
        public string JobNumber { get; set; }

        /// <summary>
        /// 职位
        /// </summary>
        public string JobTitle { get; set; }

        /// <summary>
        /// 业绩绩效
        /// </summary>
        public Nullable<decimal> PerforSumFee { get; set; }

        /// <summary>
        /// 管理绩效
        /// </summary>
        public Nullable<decimal> PerforManagementFee { get; set; }

        /// <summary>
        /// 应发小计
        /// </summary>
        public Nullable<decimal> ShouldGiveFee { get; set; }

        /// <summary>
        /// 医院其他绩效
        /// </summary>
        public Nullable<decimal> OthePerfor { get; set; }

        /// <summary>
        /// 不公示其他绩效
        /// </summary>
        public Nullable<decimal> HideOtherPerfor { get; set; }

        /// <summary>
        /// 夜班费
        /// </summary>
        public Nullable<decimal> NightWorkPerfor { get; set; }

        /// <summary>
        /// 实发绩效
        /// </summary>
        public Nullable<decimal> RealGiveFee { get; set; }

        /// <summary>
        /// 预留比例
        /// </summary>
        public Nullable<decimal> ReservedRatio { get; set; }

        /// <summary>
        /// 预留比例金额
        /// </summary>
        public Nullable<decimal> ReservedRatioFee { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<decimal> Punishment { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<decimal> GiveFee { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<decimal> Adjust { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<decimal> AdjustLaterOtherFee { get; set; }

        /// <summary>
        /// 银行卡号
        /// </summary>
        public string BankCard { get; set; }
        /// <summary>
        /// 正式/临聘
        /// </summary>
        public string JobCategory { get; set; }
        /// <summary>
        /// 职务
        /// </summary>
        public string Duty { get; set; }
        /// <summary>
        /// 职称
        /// </summary>
        public string TitlePosition { get; set; }

        


    }
}
