﻿namespace Performance.DtoModels
{
    public class SecondColumnDictionary
    {
        /// <summary>
        /// 描述
        /// </summary>
        public string Label { get; set; }
        /// <summary>
        /// 主键
        /// </summary>
        public string Key { get; set; }
        /// <summary>
        /// 是否显示 true显示
        /// </summary>
        public bool IsTrue { get; set; }
        /// <summary>
        /// 宽度
        /// </summary>
        public string Width { get; set; }
        /// <summary>
        /// 排序
        /// </summary>
        public int Sort { get; set; }
        /// <summary>
        /// 位置 Top、Table
        /// </summary>
        public string Site { get; set; }
        /// <summary>
        /// 类型 单项奖励：SingleAwards，工作量：Workload
        /// </summary>
        public string Type { get; set; }
        /// <summary>
        /// 颜色class名称
        /// </summary>
        public string Color { get; set; }

        public SecondColumnDictionary()
        {
        }

        public SecondColumnDictionary(string label, string key, bool isTrue, int sort, string site = "Table", string type = "", string color = "", int? width = null)
        {
            Label = label;
            Key = key;
            IsTrue = isTrue;
            Sort = sort;
            Site = site;
            Type = type;
            Color = color;
            Width = width.HasValue ? width.ToString() : ((label ?? "").Length * 20 + 10).ToString();
        }
    }
}
