﻿using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Options;
using Performance.DtoModels.AppSettings;
using Performance.EntityModels;  
using System;

namespace Performance.Api.Configurations
{
    public static class DatabaseConfig
    {
        public static void AddDatabaseConfiguration(this IServiceCollection services)
        {
            if (services == null) throw new ArgumentNullException(nameof(services));

            var connection = services.BuildServiceProvider().GetService<IOptions<AppConnection>>();

            services.AddDbContext<PerformanceDbContext>(options =>
            {
                options.UseMySql(
                    connection.Value.PerformanceConnectionString,
                    ServerVersion.AutoDetect(connection.Value.PerformanceConnectionString),
                    optionBuilder =>
                    {
                        optionBuilder.EnableStringComparisonTranslations(true);
                        optionBuilder.EnableRetryOnFailure();
                    });
            }, ServiceLifetime.Transient);
        }
    }
}
