﻿//-----------------------------------------------------------------------
// <copyright file=" report_statistics_selection.cs">
// * FileName: .cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 
    /// </summary>
    [Table("report_statistics_selection")]
    public class report_statistics_selection
    {
        [Key]
        public int ID { get; set; }

        public int? StatisticsID { get; set; }

        /// <summary>
        /// 条件标题
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// 排序
        /// </summary>
        public decimal? Sort { get; set; }

        /// <summary>
        /// 条件SQL语句
        /// </summary>
        public string Content { get; set; }

        /// <summary>
        /// 条件类型（1固定条件，2需要通过语句获取）
        /// </summary>
        public int Type { get; set; }

        /// <summary>
        /// 控件名称
        /// </summary>
        public string InputName { get; set; }

        /// <summary>
        /// 控件类型（1：input框、2：radio单选、3：checkbox多选、4：select单选、5：select多选、6：自动补全单选、7：自动补全多选、10：日期区间）
        /// </summary>
        public string InputType { get; set; }

        /// <summary>
        /// 是否必填(1表示必填0表示非必填）
        /// </summary>
        public int? Required { get; set; }

        /// <summary>
        /// 条件加载方式 1 立即加载 2 联动加载 3 自动补全
        /// </summary>
        public int LoadType { get; set; }

        /// <summary>
        /// 默认值类型(1 固定文本 2 动态结果第一项)
        /// </summary>
        public int? DefaultType { get; set; }

        /// <summary>
        /// 默认值文本
        /// </summary>
        public string DefaultValue { get; set; }

        /// <summary>
        /// 条件状态 1 正常 2 可用但不显示 3 不显示不可用 4 不可用但显示
        /// </summary>
        public int? State { get; set; }
    }
}