﻿using AutoMapper;
using Microsoft.Extensions.DependencyInjection;
using Performance.DtoModels.AutoMapper;
using System;

namespace Performance.Api.Configurations
{
    public static class AutoMapperConfig
    {
        public static void AddAutoMapperConfiguration(this IServiceCollection services)
        {
            if (services == null) throw new ArgumentNullException(nameof(services));

            Mapper.Initialize(cfg => cfg.AddProfile<AutoMapperConfigs>());
            services.AddAutoMapper();
        }
    }
}
