//-----------------------------------------------------------------------
// <copyright file=" ag_headsource.cs">
// * FileName: 二次绩效顶部数据.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 二次绩效顶部数据
    /// </summary>
    [Table("ag_headsource")]
    public class ag_headsource
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int Id { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int SecondId { get; set; }

        /// <summary>
        /// 可分配绩效
        /// </summary>
        public Nullable<decimal> TotalPerformance { get; set; }

        /// <summary>
        /// 医院其他绩效
        /// </summary>
        public Nullable<decimal> HosOtherPerformance { get; set; }

        /// <summary>
        /// 夜班绩效总和
        /// </summary>
        public Nullable<decimal> NightShiftWorkPerforTotal { get; set; }

        /// <summary>
        /// 科室总绩效
        /// </summary>
        public Nullable<decimal> TotalDistPerformance { get; set; }

        /// <summary>
        /// 主任基础绩效
        /// </summary>
        public Nullable<decimal> DirectorBasisPerformance { get; set; }

        /// <summary>
        /// 科室单项奖励
        /// </summary>
        public Nullable<decimal> TheTotalAllocationOfPerformanceResults { get; set; }

        /// <summary>
        /// 业绩分配绩效总额
        /// </summary>
        public Nullable<decimal> BasisPerformance { get; set; }

        /// <summary>
        /// 年资职称绩效占比
        /// </summary>
        public Nullable<decimal> SeniorityTitlesAccountedPerformance { get; set; }

        /// <summary>
        /// 年资职称绩效
        /// </summary>
        public Nullable<decimal> SeniorityTitlesPerformance { get; set; }

        /// <summary>
        /// 工作量绩效占比
        /// </summary>
        public Nullable<decimal> Workload_Ratio_Default { get; set; }

        /// <summary>
        /// 工作量分配绩效金额
        /// </summary>
        public Nullable<decimal> Workload_Amount_Default { get; set; }

        /// <summary>
        /// 满勤天数
        /// </summary>
        public Nullable<decimal> DaysFullAttendance { get; set; }

        /// <summary>
        /// 科室人均
        /// </summary>
        public Nullable<decimal> DepartmentsPerCapita { get; set; }

        /// <summary>
        /// 发放月份
        /// </summary>
        public string PaymentOfTheMonth { get; set; }

        /// <summary>
        /// 科室核算人数
        /// </summary>
        public Nullable<decimal> TheNumberOfAccountingDepartment { get; set; }
    }
}
