﻿using Microsoft.Extensions.Logging;
using Performance.DtoModels;
using Performance.Services.ExtractExcelService.SheetDataWrite;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.Services.ExtractExcelService
{
    public class WriteDataFactory
    {
        public ISheetDataWrite GetWriteData(SheetType sheetType, ILogger logger)
        {
            ISheetDataWrite factory;
            switch (sheetType)
            {
                //case SheetType.Employee:
                //    factory = new EmployeeDataWrite();
                //    break;

                //case SheetType.ClinicEmployee:
                //    factory = new ClinicEmployeeDataWrite();
                //    break;

                case SheetType.OtherIncome:
                case SheetType.Expend:
                    factory = new OtherIncomeDataWrite(logger);
                    break;

                case SheetType.Income:
                    factory = new IncomeDataWrite(logger);
                    break;

                case SheetType.Workload:
                case SheetType.OtherWorkload:
                    factory = new WorkloadDataWrite(logger);
                    break;

                case SheetType.AccountBasic:
                    factory = new AccountBasicDataWrite(logger);
                    break;

                case SheetType.SpecialUnit:
                    factory = new SpecialUnitDataWrite(logger);
                    break;

                //case SheetType.AccountExtra:
                //case SheetType.PersonExtra:
                //case SheetType.AccountScoreAverage:
                //case SheetType.BudgetRatio:
                //case SheetType.AssessBeforeOtherFee:
                //    factory = new DepartmentDataWrite(logger);
                //    break;

                case SheetType.AccountExtra:
                case SheetType.AccountDrugAssess:
                case SheetType.AccountMaterialsAssess:
                case SheetType.AccountScoreAverage:
                case SheetType.BudgetRatio:
                case SheetType.AssessBeforeOtherFee:
                case SheetType.AccountAdjustLaterOtherFee:
                case SheetType.WorkloadMedicineProp:
                case SheetType.WorkloadCMI:
                case SheetType.WorkloadIncline:
                    factory = new AccountExtraDataWrite(logger);
                    break;

                default:
                    return null;
            }
            return factory;
        }
    }
}
