//-----------------------------------------------------------------------
// <copyright file=" per_allot.cs">
// * FileName: 医院绩效分配.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 医院绩效分配
    /// </summary>
    [Table("per_allot")]
    public class per_allot
    {
        /// <summary>
        /// ID
        /// </summary>
        [Key]
        public int ID { get; set; }

        /// <summary>
        /// 医院ID
        /// </summary>
        public int HospitalId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> CreateUser { get; set; }

        /// <summary>
        /// 绩效统计时间
        /// </summary>
        public Nullable<DateTime> CreateDate { get; set; }

        /// <summary>
        /// 绩效发放年
        /// </summary>
        public int Year { get; set; }

        /// <summary>
        /// 绩效发放月
        /// </summary>
        public int Month { get; set; }

        /// <summary>
        /// 绩效别名
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 绩效发放总金额
        /// </summary>
        public Nullable<decimal> AllotFee { get; set; }

        /// <summary>
        /// 文件路径
        /// </summary>
        public string Path { get; set; }

        /// <summary>
        /// 上传日期
        /// </summary>
        public Nullable<DateTime> UploadDate { get; set; }

        /// <summary>
        /// 0 数据未上传 1 数据已上传 2 正在校验数据 3 数据验证通过 4 数据错误 5 正在生成绩效 6 下发绩效 7 绩效解析失败 8 归档 9 等待生成 10 绩效结果解析成功
        /// </summary>
        public int States { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 提取绩效数据文件生成路径
        /// </summary>
        public string ExtractPath { get; set; }

        /// <summary>
        /// 是否在抽取数据0 否、1 是、2 抽取成功、3 抽取失败
        /// </summary>
        public Nullable<int> IsExtracting { get; set; }

        /// <summary>
        /// 数据抽取起始时间
        /// </summary>
        public Nullable<DateTime> ExtractTime { get; set; }

        /// <summary>
        /// 1、人事科提交重新生成 2、生成成功 3、原始数据修改
        /// </summary>
        public int Generate { get; set; }

        /// <summary>
        /// 0 不显示 1 显示
        /// </summary>
        public int ShowFormula { get; set; }

        /// <summary>
        /// 自定义提取绩效数据文件生成路径
        /// </summary>
        public string CustomExtractPath { get; set; }

        /// <summary>
        /// 是否修改过配置 1修改过 0未修改
        /// </summary>
        public int IsModifyConfig { get; set; }
        /// <summary>
        /// 归档日期
        /// </summary>
        public Nullable<DateTime> PigeonholeDate { get; set; }
    }
}
