//-----------------------------------------------------------------------
// <copyright file=" per_assess_scheme.cs">
// * FileName: 考核方案.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 考核方案
    /// </summary>
    [Table("per_assess_scheme")]
    public class per_assess_scheme
    {
        /// <summary>
        /// 考核方案Id
        /// </summary>
        [Key]
        public int Id { get; set; }

        /// <summary>
        /// 绩效ID
        /// </summary>
        public Nullable<int> AllotId { get; set; }
        /// <summary>
        /// 考核类型ID
        /// </summary>
        public int AssessId { get; set; }
        /// <summary>
        /// 考核方案编码
        /// </summary>
        public string SchemeCode { get; set; }
        /// <summary>
        /// 考核方案名称
        /// </summary>
        public string SchemeName { get; set; }
        /// <summary>
        /// 考核方案备注
        /// </summary>
        public string SchemeRemarks { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime? CreateTime { get; set; }
        /// <summary>
        /// 最后修改人
        /// </summary>
        public int UpdateBy { get; set; }
        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime? UpdateTime { get; set; }
    }
}
