﻿using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels.Entity
{
    [Table("per_attendance_dept_report")]
    public class per_attendance_dept_report
    {
        [Key]
        public int Id { get; set; }
        /// <summary>
        /// 医院Id
        /// </summary>
        public int HospitalId { get; set; }
        /// <summary>
        /// 绩效Id
        /// </summary>
        public int AllotId { get; set; }
        /// <summary>
        /// 核算单元编码
        /// </summary>
        public string Code { get; set; }
        /// <summary>
        /// 人员类别
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
        /// <summary>
        /// 工号
        /// </summary>
        public string PersonnelNumber { get; set; }
        /// <summary>
        /// 姓名
        /// </summary>
        public string PersonnelName { get; set; }
        /// <summary>
        /// 人员系数
        /// </summary>
        public decimal? PermanentStaff { get; set; }
        /// <summary>
        /// 在科开始时间
        /// </summary>
        public DateTime? BeginDate { get; set; }
        /// <summary>
        /// 在科结束时间
        /// </summary>
        public DateTime? EndDate { get; set; }
        /// <summary>
        /// 全勤天数
        /// </summary>
        public int WorkFullDays { get; set; }
        /// <summary>
        /// 出勤天数
        /// </summary>
        public int AttendanceDays { get; set; }
        /// <summary>
        /// 核减天数
        /// </summary>
        public int DeductionDays { get; set; }
        /// <summary>
        /// 不核减天数
        /// </summary>
        public int NoDeductionDays { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime? CreateTime { get; set; }
    }
}
