﻿using System.Security.Cryptography;
using System.Text;

namespace Performance.Infrastructure
{
    public class PwdHelper
    {
        /// <summary>
        /// 一次加密不加盐
        /// </summary>
        /// <param name="password"></param>
        /// <returns></returns>
        public static string MD5(string password)
        {
            return MD5Encrypt(password);
        }

        /// <summary>
        /// 一次加密加盐
        /// </summary>
        /// <param name="password"></param>
        /// <param name="salt"></param>
        /// <returns></returns>
        public static string MD5AndSalt(string password, string salt = "Suvalue")
        {
            return MD5Encrypt(password + salt);
        }

        /// <summary>
        /// 两次加密加盐
        /// </summary>
        /// <param name="password"></param>
        /// <param name="salt"></param>
        /// <returns></returns>
        public static string MD5AndSalt2(string password, string salt = "Suvalue")
        {
            return MD5Encrypt(MD5Encrypt(password) + salt);
        }

        /// <summary>
        /// 32位MD5加密
        /// </summary>
        /// <param name="password"></param>
        /// <returns></returns>
        private static string MD5Encrypt(string password)
        {
            MD5CryptoServiceProvider md5Hasher = new MD5CryptoServiceProvider();
            byte[] data = md5Hasher.ComputeHash(Encoding.Default.GetBytes(password));
            StringBuilder sBuilder = new StringBuilder();
            for (int i = 0; i < data.Length; i++)
            {
                sBuilder.Append(data[i].ToString("x2"));//转化为小写的32进制
            }
            return sBuilder.ToString();
        }
    }
}